/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.b;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int nZ;
    private final List<DataSet> rq;
    private final Status kW;
    private final List<Bucket> tL;
    private int tM;
    private final List<DataSource> rA;
    private final List<DataType> tN;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new b();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.nZ = versionCode;
        this.kW = status;
        this.tM = batchCount;
        this.rA = uniqueDataSources;
        this.tN = uniqueDataTypes;
        this.rq = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet safeParcelable : dataSets) {
            this.rq.add(new DataSet(safeParcelable, uniqueDataSources, uniqueDataTypes));
        }
        this.tL = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.tL.add(new Bucket(rawBucket, uniqueDataSources, uniqueDataTypes));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.nZ = 5;
        this.rq = dataSets;
        this.kW = status;
        this.tL = buckets;
        this.tM = 1;
        this.rA = new ArrayList<DataSource>();
        this.tN = new ArrayList<DataType>();
    }

    public static DataReadResult a(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource safeParcelable : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(safeParcelable));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.rq) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.rq) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.rq;
    }

    public List<Bucket> getBuckets() {
        return this.tL;
    }

    public int dk() {
        return this.tM;
    }

    public void b(DataReadResult dataReadResult) {
        for (DataSet safeParcelable : dataReadResult.getDataSets()) {
            this.a(safeParcelable, this.rq);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.a(bucket, this.tL);
        }
    }

    private void a(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.a(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void a(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.b(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.a(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.tL.add(bucket);
    }

    @Override
    public Status getStatus() {
        return this.kW;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.c((DataReadResult)that);
    }

    private boolean c(DataReadResult dataReadResult) {
        return this.kW.equals(dataReadResult.kW) && l.equal(this.rq, dataReadResult.rq) && l.equal(this.tL, dataReadResult.tL);
    }

    public int hashCode() {
        return l.hashCode(this.kW, this.rq, this.tL);
    }

    public String toString() {
        return l.e(this).a("status", this.kW).a("dataSets", this.rq.size() > 5 ? this.rq.size() + " data sets" : this.rq).a("buckets", this.tL.size() > 5 ? this.tL.size() + " buckets" : this.tL).toString();
    }

    int getVersionCode() {
        return this.nZ;
    }

    List<RawBucket> dl() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.tL.size());
        for (Bucket bucket : this.tL) {
            arrayList.add(new RawBucket(bucket, this.rA, this.tN));
        }
        return arrayList;
    }

    List<RawDataSet> dm() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.rq.size());
        for (DataSet dataSet : this.rq) {
            arrayList.add(new RawDataSet(dataSet, this.rA, this.tN));
        }
        return arrayList;
    }

    List<DataSource> co() {
        return this.rA;
    }

    List<DataType> dn() {
        return this.tN;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }
}

