/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.s;
import com.google.android.gms.internal.w;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int nZ;
    private final Session rf;
    private final List<DataSet> rq;
    private final List<DataPoint> tA;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new s();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints) {
        this.nZ = versionCode;
        this.rf = session;
        this.rq = Collections.unmodifiableList(dataSets);
        this.tA = Collections.unmodifiableList(aggregateDataPoints);
    }

    private SessionInsertRequest(Builder builder) {
        this.nZ = 1;
        this.rf = builder.rf;
        this.rq = Collections.unmodifiableList(builder.rq);
        this.tA = Collections.unmodifiableList(builder.tA);
    }

    public Session getSession() {
        return this.rf;
    }

    public List<DataSet> getDataSets() {
        return this.rq;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.tA;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof SessionInsertRequest && this.a((SessionInsertRequest)o2);
    }

    private boolean a(SessionInsertRequest sessionInsertRequest) {
        return l.equal(this.rf, sessionInsertRequest.rf) && l.equal(this.rq, sessionInsertRequest.rq) && l.equal(this.tA, sessionInsertRequest.tA);
    }

    public int hashCode() {
        return l.hashCode(this.rf, this.rq, this.tA);
    }

    public String toString() {
        return l.e(this).a("session", this.rf).a("dataSets", this.rq).a("aggregateDataPoints", this.tA).toString();
    }

    int getVersionCode() {
        return this.nZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        s.a(this, dest, flags);
    }

    public static class Builder {
        private Session rf;
        private List<DataSet> rq = new ArrayList<DataSet>();
        private List<DataPoint> tA = new ArrayList<DataPoint>();
        private List<DataSource> tB = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.rf = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            m.b(dataSet != null, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            m.a(!this.tB.contains(dataSource), "Data set for this data source %s is already added.", dataSource);
            List<DataPoint> list = dataSet.getDataPoints();
            m.b(!list.isEmpty(), (Object)"No data points specified in the input data set.");
            this.tB.add(dataSource);
            this.rq.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            m.b(aggregateDataPoint != null, (Object)"Must specify a valid aggregate data point.");
            long l2 = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            m.b(l2 > 0L && l3 > l2, "Aggregate data point should have valid start and end times: %s", aggregateDataPoint);
            DataSource dataSource = aggregateDataPoint.getDataSource();
            m.a(!this.tB.contains(dataSource), "Data set/Aggregate data point for this data source %s is already added.", dataSource);
            this.tB.add(dataSource);
            this.tA.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            m.a(this.rf != null, (Object)"Must specify a valid session.");
            m.a(this.rf.getEndTime(TimeUnit.MILLISECONDS) != 0L, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.db();
            return new SessionInsertRequest(this);
        }

        private void d(DataPoint dataPoint) {
            this.f(dataPoint);
            this.e(dataPoint);
        }

        private void e(DataPoint dataPoint) {
            long l2 = this.rf.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = this.rf.getEndTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l5 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l4 != 0L && l5 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l5 > l3) {
                    l5 = w.a(l5, TimeUnit.NANOSECONDS, timeUnit);
                }
                m.a(l4 >= l2 && l5 <= l3, "Data point %s has start and end times outside session interval [%d, %d]", dataPoint, l2, l3);
                if (l5 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l5, timeUnit}));
                    dataPoint.setTimeInterval(l4, l5, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void f(DataPoint dataPoint) {
            long l2 = this.rf.getStartTime(TimeUnit.NANOSECONDS);
            long l3 = this.rf.getEndTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 < l2 || l4 > l3) {
                    l4 = w.a(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                m.a(l4 >= l2 && l4 <= l3, "Data point %s has time stamp outside session interval [%d, %d]", dataPoint, l2, l3);
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l4) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimestamp(l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void db() {
            for (DataSet safeParcelable : this.rq) {
                for (DataPoint dataPoint : safeParcelable.getDataPoints()) {
                    this.d(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.tA) {
                this.d(dataPoint);
            }
        }
    }
}

