/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.i;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int nZ;
    private final String mName;
    private final List<Field> rM;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new i();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields) {
        this.nZ = versionCode;
        this.mName = name;
        this.rM = Collections.unmodifiableList(fields);
    }

    private DataTypeCreateRequest(Builder builder) {
        this.nZ = 1;
        this.mName = builder.mName;
        this.rM = Collections.unmodifiableList(builder.rM);
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.rM;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataTypeCreateRequest && this.a((DataTypeCreateRequest)o2);
    }

    private boolean a(DataTypeCreateRequest dataTypeCreateRequest) {
        return l.equal(this.mName, dataTypeCreateRequest.mName) && l.equal(this.rM, dataTypeCreateRequest.rM);
    }

    public int hashCode() {
        return l.hashCode(this.mName, this.rM);
    }

    public String toString() {
        return l.e(this).a("name", this.mName).a("fields", this.rM).toString();
    }

    int getVersionCode() {
        return this.nZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        i.a(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> rM = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.rM.contains(field)) {
                this.rM.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            m.b(name != null || !name.isEmpty(), (Object)"Invalid name specified");
            Field field = new Field(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            m.a(this.mName != null, (Object)"Must set the name");
            m.a(!this.rM.isEmpty(), (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

