/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.g;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int nZ;
    private final List<DataType> ro;
    private final List<DataSource> sZ;
    private final long pl;
    private final long rd;
    private final List<DataType> td;
    private final List<DataSource> te;
    private final int rr;
    private final long tf;
    private final DataSource tg;
    private final int th;
    private final boolean ti;
    private final boolean tj;
    private final boolean tk;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new g();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean disableTransformations, boolean flushBeforeRead, boolean serverQueriesEnabled) {
        this.nZ = versionCode;
        this.ro = Collections.unmodifiableList(dataTypes);
        this.sZ = Collections.unmodifiableList(dataSources);
        this.pl = startTimeMillis;
        this.rd = endTimeMillis;
        this.td = Collections.unmodifiableList(aggregatedDataTypes);
        this.te = Collections.unmodifiableList(aggregatedDataSources);
        this.rr = bucketType;
        this.tf = bucketDurationMillis;
        this.tg = activityDataSource;
        this.th = limit;
        this.ti = disableTransformations;
        this.tj = flushBeforeRead;
        this.tk = serverQueriesEnabled;
    }

    private DataReadRequest(Builder builder) {
        this.nZ = 2;
        this.ro = Collections.unmodifiableList(builder.ro);
        this.sZ = Collections.unmodifiableList(builder.sZ);
        this.pl = builder.pl;
        this.rd = builder.rd;
        this.td = Collections.unmodifiableList(builder.td);
        this.te = Collections.unmodifiableList(builder.te);
        this.rr = builder.rr;
        this.tf = builder.tf;
        this.tg = builder.tg;
        this.th = builder.th;
        this.ti = builder.ti;
        this.tj = builder.tj;
        this.tk = builder.tk;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.pl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.rd, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.ro;
    }

    public List<DataSource> getDataSources() {
        return this.sZ;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.td;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.te;
    }

    public int getBucketType() {
        return this.rr;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.tf, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.tg;
    }

    public int getLimit() {
        return this.th;
    }

    public boolean cN() {
        return this.ti;
    }

    public boolean cO() {
        return this.tk;
    }

    public boolean cP() {
        return this.tj;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.a((DataReadRequest)that);
    }

    private boolean a(DataReadRequest dataReadRequest) {
        return this.ro.equals(dataReadRequest.ro) && this.sZ.equals(dataReadRequest.sZ) && this.pl == dataReadRequest.pl && this.rd == dataReadRequest.rd && this.rr == dataReadRequest.rr && this.te.equals(dataReadRequest.te) && this.td.equals(dataReadRequest.td) && l.equal(this.tg, dataReadRequest.tg) && this.tf == dataReadRequest.tf && this.tk == dataReadRequest.tk;
    }

    public int hashCode() {
        return l.hashCode(this.rr, this.pl, this.rd);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.ro.isEmpty()) {
            for (DataType safeParcelable : this.ro) {
                stringBuilder.append(safeParcelable.ct()).append(" ");
            }
        }
        if (!this.sZ.isEmpty()) {
            for (DataSource dataSource : this.sZ) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.rr != 0) {
            stringBuilder.append("bucket by ").append(Bucket.M(this.rr));
            if (this.tf > 0L) {
                stringBuilder.append(" >").append(this.tf).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.td.isEmpty()) {
            for (DataType dataType : this.td) {
                stringBuilder.append(dataType.ct()).append(" ");
            }
        }
        if (!this.te.isEmpty()) {
            for (DataSource dataSource : this.te) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.pl, this.pl, this.rd, this.rd));
        if (this.tg != null) {
            stringBuilder.append("activities: ").append(this.tg.toDebugString());
        }
        if (this.tk) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.nZ;
    }

    public long ch() {
        return this.rd;
    }

    public long cg() {
        return this.pl;
    }

    public long cQ() {
        return this.tf;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        g.a(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> ro = new ArrayList<DataType>();
        private List<DataSource> sZ = new ArrayList<DataSource>();
        private List<DataType> td = new ArrayList<DataType>();
        private List<DataSource> te = new ArrayList<DataSource>();
        private DataSource tg;
        private long pl;
        private long rd;
        private int rr = 0;
        private long tf = 0L;
        private int th = 0;
        private boolean ti = false;
        private boolean tj = false;
        private boolean tk = false;

        public Builder read(DataSource dataSource) {
            m.a(dataSource, (Object)"Attempting to add a null data source");
            m.b(!this.te.contains(dataSource), (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.sZ.contains(dataSource)) {
                this.sZ.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            m.a(dataType, (Object)"Attempting to use a null data type");
            m.a(!this.td.contains(dataType), (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.ro.contains(dataType)) {
                this.ro.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            m.a(dataSource, (Object)"Attempting to add a null data source");
            m.a(!this.sZ.contains(dataSource), (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            m.b(DataType.AGGREGATE_INPUT_TYPES.contains(dataType), "Unsupported input data type specified for aggregation: %s", dataType);
            m.b(DataType.getAggregatesForInput(dataType).contains(outputDataType), "Invalid output aggregate data type specified: %s -> %s", dataType, outputDataType);
            if (!this.te.contains(dataSource)) {
                this.te.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            m.a(inputDataType, (Object)"Attempting to use a null data type");
            m.a(!this.ro.contains(inputDataType), (Object)"Cannot add the same data type as aggregated and detailed");
            m.b(DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), "Unsupported input data type specified for aggregation: %s", inputDataType);
            m.b(DataType.getAggregatesForInput(inputDataType).contains(outputDataType), "Invalid output aggregate data type specified: %s -> %s", inputDataType, outputDataType);
            if (!this.td.contains(inputDataType)) {
                this.td.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            m.b(this.rr == 0, "Bucketing strategy already set to %s", this.rr);
            m.b(duration > 0, "Must specify a valid minimum duration for an activity segment: %d", duration);
            this.rr = 1;
            this.tf = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            m.b(this.rr == 0, "Bucketing strategy already set to %s", this.rr);
            m.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.rr = 3;
            this.tf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            m.b(this.rr == 0, "Bucketing strategy already set to %s", this.rr);
            m.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            m.b(activityDataSource != null, (Object)"Invalid activity data source specified");
            m.b(activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), "Invalid activity data source specified: %s", activityDataSource);
            this.tg = activityDataSource;
            this.rr = 3;
            this.tf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            m.b(this.rr == 0, "Bucketing strategy already set to %s", this.rr);
            m.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.rr = 4;
            this.tf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            m.b(this.rr == 0, "Bucketing strategy already set to %s", this.rr);
            m.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            m.b(activityDataSource != null, (Object)"Invalid activity data source specified");
            m.b(activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), "Invalid activity data source specified: %s", activityDataSource);
            this.tg = activityDataSource;
            this.rr = 4;
            this.tf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            m.b(this.rr == 0, "Bucketing strategy already set to %s", this.rr);
            m.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.rr = 2;
            this.tf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.pl = timeUnit.toMillis(start);
            this.rd = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.tk = true;
            return this;
        }

        public Builder setLimit(int limit) {
            m.b(limit > 0, "Invalid limit %d is specified", limit);
            this.th = limit;
            return this;
        }

        public DataReadRequest build() {
            m.a(!this.sZ.isEmpty() || !this.ro.isEmpty() || !this.te.isEmpty() || !this.td.isEmpty(), (Object)"Must add at least one data source (aggregated or detailed)");
            m.a(this.pl > 0L, "Invalid start time: %s", this.pl);
            m.a(this.rd > 0L && this.rd > this.pl, "Invalid end time: %s", this.rd);
            boolean bl2 = this.te.isEmpty() && this.td.isEmpty();
            m.a(bl2 && this.rr == 0 || !bl2 && this.rr != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

