/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.p;
import java.util.concurrent.TimeUnit;

public class Session
implements SafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int nZ;
    private final long pl;
    private final long rd;
    private final String mName;
    private final String se;
    private final String sf;
    private final int rp;
    private final a rD;
    public static final Parcelable.Creator<Session> CREATOR = new p();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activityType, a application) {
        this.nZ = versionCode;
        this.pl = startTimeMillis;
        this.rd = endTimeMillis;
        this.mName = name;
        this.se = identifier;
        this.sf = description;
        this.rp = activityType;
        this.rD = application;
    }

    private Session(Builder builder) {
        this.nZ = 2;
        this.pl = builder.pl;
        this.rd = builder.rd;
        this.mName = builder.mName;
        this.se = builder.se;
        this.sf = builder.sf;
        this.rp = builder.rp;
        this.rD = builder.rD;
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.pl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.rd, TimeUnit.MILLISECONDS);
    }

    public boolean isOngoing() {
        return this.rd == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.se;
    }

    public String getDescription() {
        return this.sf;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.rp);
    }

    public int ce() {
        return this.rp;
    }

    public a cp() {
        return this.rD;
    }

    public String getAppPackageName() {
        return this.rD == null ? null : this.rD.getPackageName();
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Session && this.a((Session)o2);
    }

    private boolean a(Session session) {
        return this.pl == session.pl && this.rd == session.rd && l.equal(this.mName, session.mName) && l.equal(this.se, session.se) && l.equal(this.sf, session.sf) && l.equal(this.rD, session.rD) && this.rp == session.rp;
    }

    public int hashCode() {
        return l.hashCode(this.pl, this.rd, this.se);
    }

    public String toString() {
        return l.e(this).a("startTime", this.pl).a("endTime", this.rd).a("name", this.mName).a("identifier", this.se).a("description", this.sf).a("activity", this.rp).a("application", this.rD).toString();
    }

    int getVersionCode() {
        return this.nZ;
    }

    public long cg() {
        return this.pl;
    }

    public long ch() {
        return this.rd;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        p.a(this, dest, flags);
    }

    public static class Builder {
        private long pl = 0L;
        private long rd = 0L;
        private String mName = null;
        private String se;
        private String sf;
        private int rp = 4;
        private a rD;

        public Builder setStartTime(long time, TimeUnit timeUnit) {
            m.a(time > 0L, (Object)"Start time should be positive.");
            this.pl = timeUnit.toMillis(time);
            return this;
        }

        public Builder setEndTime(long time, TimeUnit timeUnit) {
            m.a(time >= 0L, (Object)"End time should be positive.");
            this.rd = timeUnit.toMillis(time);
            return this;
        }

        public Builder setName(String name) {
            m.b(name.length() <= 100, "Session name cannot exceed %d characters", 100);
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            m.h(identifier != null && TextUtils.getTrimmedLength((CharSequence)identifier) > 0);
            this.se = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            m.b(description.length() <= 1000, "Session description cannot exceed %d characters", 1000);
            this.sf = description;
            return this;
        }

        public Builder setActivity(String activity) {
            return this.Y(FitnessActivities.G(activity));
        }

        public Builder Y(int n2) {
            this.rp = n2;
            return this;
        }

        public Session build() {
            m.a(this.pl > 0L, (Object)"Start time should be specified.");
            m.a(this.rd == 0L || this.rd > this.pl, (Object)"End time should be later than start time.");
            if (this.se == null) {
                this.se = (this.mName == null ? "" : this.mName) + this.pl;
            }
            return new Session(this);
        }
    }
}

