/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.i;
import com.google.android.gms.internal.aj;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int nZ;
    private final String rN;
    private final String rO;
    private final String rk;
    private final String rP;
    private final int rB;
    private final int rQ;
    public static final Parcelable.Creator<Device> CREATOR = new i();

    public static Device getLocalDevice(Context context) {
        int n2 = Device.r(context);
        String string2 = Device.q(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string2, n2, 2);
    }

    private static String q(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    private static int r(Context context) {
        switch (Device.t(context)) {
            case 10: {
                return Device.s(context) ? 3 : 0;
            }
            case 8: 
            case 9: {
                return 0;
            }
        }
        return Device.v(context) ? 1 : 2;
    }

    public static boolean s(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        return (configuration.uiMode & 0xF) == 6;
    }

    private static int t(Context context) {
        return Device.u(context) % 1000 / 100 + 5;
    }

    private static int u(Context context) {
        try {
            String string2 = "com.google.android.gms";
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string2, 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"Fitness", (String)"Could not find package info for Google Play Services");
            return -1;
        }
    }

    private static boolean v(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getPhoneType() != 0;
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type) {
        this(manufacturer, model, uid, type);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.nZ = versionCode;
        this.rN = m.f(manufacturer);
        this.rO = m.f(model);
        this.rk = "";
        this.rP = m.f(uid);
        this.rB = type;
        this.rQ = platformType;
    }

    public String getManufacturer() {
        return this.rN;
    }

    public String getModel() {
        return this.rO;
    }

    public String getVersion() {
        return this.rk;
    }

    public String getUid() {
        return this.rP;
    }

    public int getType() {
        return this.rB;
    }

    public int cu() {
        return this.rQ;
    }

    private boolean cv() {
        return this.cu() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.rN, this.rO, this.rP);
    }

    Device cw() {
        return new Device(aj.K(this.rN), aj.K(this.rO), aj.K(this.rk), this.rP, this.rB);
    }

    public String cx() {
        return aj.cF() || this.cv() ? this.rP : aj.K(this.rP);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.rk, this.rB, this.rQ);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.a((Device)that);
    }

    private boolean a(Device device) {
        return l.equal(this.rN, device.rN) && l.equal(this.rO, device.rO) && l.equal(this.rk, device.rk) && l.equal(this.rP, device.rP) && this.rB == device.rB && this.rQ == device.rQ;
    }

    public int hashCode() {
        return l.hashCode(this.rN, this.rO, this.rk, this.rP, this.rB);
    }

    int getVersionCode() {
        return this.nZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        i.a(this, parcel, flags);
    }
}

