/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.e;
import com.google.android.gms.internal.w;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int nZ;
    private final DataSource rc;
    private long rt;
    private long ru;
    private final Value[] rv;
    private DataSource rw;
    private long rx;
    private long ry;
    public static final Parcelable.Creator<DataPoint> CREATOR = new e();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.nZ = versionCode;
        this.rc = dataSource;
        this.rw = originalDataSource;
        this.rt = timestampNanos;
        this.ru = startTimeNanos;
        this.rv = values;
        this.rx = rawTimestamp;
        this.ry = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(4, DataPoint.a(dataSources, rawDataPoint.sa), rawDataPoint.rt, rawDataPoint.ru, rawDataPoint.rv, DataPoint.a(dataSources, rawDataPoint.sb), rawDataPoint.rx, rawDataPoint.ry);
    }

    private static DataSource a(List<DataSource> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? list.get(n2) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.nZ = 4;
        this.rc = m.a(dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.rv = new Value[list.size()];
        int n2 = 0;
        for (Field field : list) {
            this.rv[n2] = new Value(field.getFormat());
            ++n2;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, "com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.rt = timeUnit.toNanos(timestamp);
        if (this.ci() && w.a(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.rt = w.a(this.rt, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean ci() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.ru = timeUnit.toNanos(startTime);
        this.rt = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n2 = this.getDataType().indexOf(field);
        return this.rv[n2];
    }

    public Value[] cj() {
        return this.rv;
    }

    public DataPoint setFloatValues(float ... values) {
        this.O(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.rv[i2].setFloat(values[i2]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.O(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.rv[i2].setInt(values[i2]);
        }
        return this;
    }

    private void O(int n2) {
        List<Field> list = this.getDataType().getFields();
        int n3 = list.size();
        m.b(n2 == n3, "Attempting to insert %s values, but needed %s: %s", n2, n3, list);
    }

    public DataType getDataType() {
        return this.rc.getDataType();
    }

    public DataSource getDataSource() {
        return this.rc;
    }

    public DataSource getOriginalDataSource() {
        return this.rw;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.rt, TimeUnit.NANOSECONDS);
    }

    public long ck() {
        return this.rx;
    }

    public long cl() {
        return this.ry;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.ru, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.rt, TimeUnit.NANOSECONDS);
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof DataPoint && this.a((DataPoint)o2);
    }

    private boolean a(DataPoint dataPoint) {
        return l.equal(this.rc, dataPoint.rc) && this.rt == dataPoint.rt && this.ru == dataPoint.ru && Arrays.equals(this.rv, dataPoint.rv) && l.equal(this.rw, dataPoint.rw);
    }

    public int hashCode() {
        return l.hashCode(this.rc, this.rt, this.ru);
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.rv), this.ru, this.rt, this.rx, this.ry, this.rc, this.rw);
    }

    public int getVersionCode() {
        return this.nZ;
    }

    public long getTimestampNanos() {
        return this.rt;
    }

    public long cm() {
        return this.ru;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        e.a(this, parcel, flags);
    }
}

