/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.d;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int nZ;
    private final long pl;
    private final long rd;
    private final Session rf;
    private final int rp;
    private final List<DataSet> rq;
    private final int rr;
    private boolean rs = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new d();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.nZ = versionCode;
        this.pl = startTimeMillis;
        this.rd = endTimeMillis;
        this.rf = session;
        this.rp = activityType;
        this.rq = dataSets;
        this.rr = bucketType;
        this.rs = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(2, bucket.pl, bucket.rd, bucket.rf, bucket.rZ, Bucket.a(bucket.rq, uniqueDataSources, uniqueDataTypes), bucket.rr, bucket.rs);
    }

    private static List<DataSet> a(List<RawDataSet> list, List<DataSource> list2, List<DataType> list3) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(list.size());
        for (RawDataSet rawDataSet : list) {
            arrayList.add(new DataSet(rawDataSet, list2, list3));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.pl, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.rd, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.rf;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.rp);
    }

    public int ce() {
        return this.rp;
    }

    public List<DataSet> getDataSets() {
        return this.rq;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.rq) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.rr;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Bucket && this.a((Bucket)o2);
    }

    private boolean a(Bucket bucket) {
        return this.pl == bucket.pl && this.rd == bucket.rd && this.rp == bucket.rp && l.equal(this.rq, bucket.rq) && this.rr == bucket.rr && this.rs == bucket.rs;
    }

    public boolean b(Bucket bucket) {
        return this.pl == bucket.pl && this.rd == bucket.rd && this.rp == bucket.rp && this.rr == bucket.rr;
    }

    public boolean cf() {
        if (this.rs) {
            return true;
        }
        for (DataSet dataSet : this.rq) {
            if (!dataSet.cf()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return l.hashCode(this.pl, this.rd, this.rp, this.rr);
    }

    public String toString() {
        return l.e(this).a("startTime", this.pl).a("endTime", this.rd).a("activity", this.rp).a("dataSets", this.rq).a("bucketType", Bucket.M(this.rr)).a("serverHasMoreData", this.rs).toString();
    }

    public static String M(int n2) {
        switch (n2) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.nZ;
    }

    public long cg() {
        return this.pl;
    }

    public long ch() {
        return this.rd;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }
}

