/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.SessionInsertRequest;
import com.google.android.gms.fitness.request.SessionReadRequest;
import com.google.android.gms.fitness.result.SessionReadResult;
import com.google.android.gms.fitness.result.SessionStopResult;

public interface SessionsApi {
    public PendingResult<Status> startSession(GoogleApiClient var1, Session var2);

    public PendingResult<SessionStopResult> stopSession(GoogleApiClient var1, String var2);

    public PendingResult<Status> insertSession(GoogleApiClient var1, SessionInsertRequest var2);

    public PendingResult<SessionReadResult> readSession(GoogleApiClient var1, SessionReadRequest var2);

    public PendingResult<Status> registerForSessions(GoogleApiClient var1, PendingIntent var2);

    public PendingResult<Status> unregisterForSessions(GoogleApiClient var1, PendingIntent var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private Session rf;
        private String re;
        private boolean rg = false;

        public ViewIntentBuilder(Context context) {
            this.mContext = context;
        }

        public ViewIntentBuilder setSession(Session session) {
            this.rf = session;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.re = packageName;
            this.rg = true;
            return this;
        }

        public Intent build() {
            m.a(this.rf != null, (Object)"Session must be set");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(Session.getMimeType(this.rf.getActivity()));
            c.a(this.rf, intent, "vnd.google.fitness.session");
            if (!this.rg) {
                this.re = this.rf.getAppPackageName();
            }
            return this.b(intent);
        }

        private Intent b(Intent intent) {
            if (this.re == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.re);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string2 = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.re, string2));
                return intent2;
            }
            return intent;
        }
    }
}

