/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.util.SparseArray;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.Field;

public class FitnessActivities {
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.activity/";
    public static final String EXTRA_STATUS = "actionStatus";
    public static final String STATUS_ACTIVE = "ActiveActionStatus";
    public static final String STATUS_COMPLETED = "CompletedActionStatus";
    private static final SparseArray<String> ra = new SparseArray(109);
    public static final String AEROBICS = "aerobics";
    public static final String BADMINTON = "badminton";
    public static final String BASEBALL = "baseball";
    public static final String BASKETBALL = "basketball";
    public static final String BIATHLON = "biathlon";
    public static final String BIKING = "biking";
    public static final String BIKING_HAND = "biking.hand";
    public static final String BIKING_MOUNTAIN = "biking.mountain";
    public static final String BIKING_ROAD = "biking.road";
    public static final String BIKING_SPINNING = "biking.spinning";
    public static final String BIKING_STATIONARY = "biking.stationary";
    public static final String BIKING_UTILITY = "biking.utility";
    public static final String BOXING = "boxing";
    public static final String CALISTHENICS = "calisthenics";
    public static final String CIRCUIT_TRAINING = "circuit_training";
    public static final String CRICKET = "cricket";
    public static final String CURLING = "curling";
    public static final String DANCING = "dancing";
    public static final String DIVING = "diving";
    public static final String ELLIPTICAL = "elliptical";
    public static final String ERGOMETER = "ergometer";
    public static final String FENCING = "fencing";
    public static final String FOOTBALL_AMERICAN = "football.american";
    public static final String FOOTBALL_AUSTRALIAN = "football.australian";
    public static final String FOOTBALL_SOCCER = "football.soccer";
    public static final String FRISBEE_DISC = "frisbee_disc";
    public static final String GARDENING = "gardening";
    public static final String GOLF = "golf";
    public static final String GYMNASTICS = "gymnastics";
    public static final String HANDBALL = "handball";
    public static final String HIKING = "hiking";
    public static final String HOCKEY = "hockey";
    public static final String HORSEBACK_RIDING = "horseback_riding";
    public static final String HOUSEWORK = "housework";
    public static final String ICE_SKATING = "ice_skating";
    public static final String IN_VEHICLE = "in_vehicle";
    public static final String JUMP_ROPE = "jump_rope";
    public static final String KAYAKING = "kayaking";
    public static final String KETTLEBELL_TRAINING = "kettlebell_training";
    public static final String KICK_SCOOTER = "kick_scooter";
    public static final String KICKBOXING = "kickboxing";
    public static final String KITESURFING = "kitesurfing";
    public static final String MARTIAL_ARTS = "martial_arts";
    public static final String MEDITATION = "meditation";
    public static final String MIXED_MARTIAL_ARTS = "martial_arts.mixed";
    public static final String ON_FOOT = "on_foot";
    public static final String OTHER = "other";
    public static final String P90X = "p90x";
    public static final String PARAGLIDING = "paragliding";
    public static final String PILATES = "pilates";
    public static final String POLO = "polo";
    public static final String RACQUETBALL = "racquetball";
    public static final String ROCK_CLIMBING = "rock_climbing";
    public static final String ROWING = "rowing";
    public static final String ROWING_MACHINE = "rowing.machine";
    public static final String RUGBY = "rugby";
    public static final String RUNNING = "running";
    public static final String RUNNING_JOGGING = "running.jogging";
    public static final String RUNNING_SAND = "running.sand";
    public static final String RUNNING_TREADMILL = "running.treadmill";
    public static final String SAILING = "sailing";
    public static final String SCUBA_DIVING = "scuba_diving";
    public static final String SKATEBOARDING = "skateboarding";
    public static final String SKATING = "skating";
    public static final String SKATING_CROSS = "skating.cross";
    public static final String SKATING_INDOOR = "skating.indoor";
    public static final String SKATING_INLINE = "skating.inline";
    public static final String SKIING = "skiing";
    public static final String SKIING_BACK_COUNTRY = "skiing.back_country";
    public static final String SKIING_CROSS_COUNTRY = "skiing.cross_country";
    public static final String SKIING_DOWNHILL = "skiing.downhill";
    public static final String SKIING_KITE = "skiing.kite";
    public static final String SKIING_ROLLER = "skiing.roller";
    public static final String SLEDDING = "sledding";
    public static final String SLEEP = "sleep";
    public static final String SNOWBOARDING = "snowboarding";
    public static final String SNOWMOBILE = "snowmobile";
    public static final String SNOWSHOEING = "snowshoeing";
    public static final String SQUASH = "squash";
    public static final String STAIR_CLIMBING = "stair_climbing";
    public static final String STAIR_CLIMBING_MACHINE = "stair_climbing.machine";
    public static final String STANDUP_PADDLEBOARDING = "standup_paddleboarding";
    public static final String STILL = "still";
    public static final String STRENGTH_TRAINING = "strength_training";
    public static final String SURFING = "surfing";
    public static final String SWIMMING = "swimming";
    public static final String SWIMMING_POOL = "swimming.pool";
    public static final String SWIMMING_OPEN_WATER = "swimming.open_water";
    public static final String TABLE_TENNIS = "table_tennis";
    public static final String TEAM_SPORTS = "team_sports";
    public static final String TENNIS = "tennis";
    public static final String TILTING = "tilting";
    public static final String TREADMILL = "treadmill";
    public static final String UNKNOWN = "unknown";
    public static final String VOLLEYBALL = "volleyball";
    public static final String VOLLEYBALL_BEACH = "volleyball.beach";
    public static final String VOLLEYBALL_INDOOR = "volleyball.indoor";
    public static final String WAKEBOARDING = "wakeboarding";
    public static final String WALKING = "walking";
    public static final String WALKING_FITNESS = "walking.fitness";
    public static final String WALKING_NORDIC = "walking.nordic";
    public static final String WALKING_TREADMILL = "walking.treadmill";
    public static final String WATER_POLO = "water_polo";
    public static final String WEIGHTLIFTING = "weightlifting";
    public static final String WHEELCHAIR = "wheelchair";
    public static final String WINDSURFING = "windsurfing";
    public static final String YOGA = "yoga";
    public static final String ZUMBA = "zumba";

    FitnessActivities() {
    }

    public static void setValue(DataPoint dataPoint, String activity) {
        dataPoint.getValue(Field.FIELD_ACTIVITY).setInt(FitnessActivities.G(activity));
    }

    public static String getValue(DataPoint dataPoint) {
        return FitnessActivities.getName(dataPoint.getValue(Field.FIELD_ACTIVITY).asInt());
    }

    public static int G(String string2) {
        int n2 = ra.indexOfValue((Object)string2);
        if (n2 < 0) {
            return 4;
        }
        int n3 = ra.keyAt(n2);
        if (n3 > 108) {
            return 4;
        }
        return n3;
    }

    public static String getName(int activity) {
        String string2 = (String)ra.get(activity);
        if (string2 == null) {
            throw new IllegalArgumentException("Unknown activity " + activity);
        }
        return string2;
    }

    public static String getMimeType(String activity) {
        return MIME_TYPE_PREFIX + activity;
    }

    static {
        ra.put(9, (Object)AEROBICS);
        ra.put(10, (Object)BADMINTON);
        ra.put(11, (Object)BASEBALL);
        ra.put(12, (Object)BASKETBALL);
        ra.put(13, (Object)BIATHLON);
        ra.put(1, (Object)BIKING);
        ra.put(14, (Object)BIKING_HAND);
        ra.put(15, (Object)BIKING_MOUNTAIN);
        ra.put(16, (Object)BIKING_ROAD);
        ra.put(17, (Object)BIKING_SPINNING);
        ra.put(18, (Object)BIKING_STATIONARY);
        ra.put(19, (Object)BIKING_UTILITY);
        ra.put(20, (Object)BOXING);
        ra.put(21, (Object)CALISTHENICS);
        ra.put(22, (Object)CIRCUIT_TRAINING);
        ra.put(23, (Object)CRICKET);
        ra.put(106, (Object)CURLING);
        ra.put(24, (Object)DANCING);
        ra.put(102, (Object)DIVING);
        ra.put(25, (Object)ELLIPTICAL);
        ra.put(103, (Object)ERGOMETER);
        ra.put(6, (Object)"exiting_vehicle");
        ra.put(26, (Object)FENCING);
        ra.put(27, (Object)FOOTBALL_AMERICAN);
        ra.put(28, (Object)FOOTBALL_AUSTRALIAN);
        ra.put(29, (Object)FOOTBALL_SOCCER);
        ra.put(30, (Object)FRISBEE_DISC);
        ra.put(31, (Object)GARDENING);
        ra.put(32, (Object)GOLF);
        ra.put(33, (Object)GYMNASTICS);
        ra.put(34, (Object)HANDBALL);
        ra.put(35, (Object)HIKING);
        ra.put(36, (Object)HOCKEY);
        ra.put(37, (Object)HORSEBACK_RIDING);
        ra.put(38, (Object)HOUSEWORK);
        ra.put(104, (Object)ICE_SKATING);
        ra.put(0, (Object)IN_VEHICLE);
        ra.put(39, (Object)JUMP_ROPE);
        ra.put(40, (Object)KAYAKING);
        ra.put(41, (Object)KETTLEBELL_TRAINING);
        ra.put(107, (Object)KICK_SCOOTER);
        ra.put(42, (Object)KICKBOXING);
        ra.put(43, (Object)KITESURFING);
        ra.put(44, (Object)MARTIAL_ARTS);
        ra.put(45, (Object)MEDITATION);
        ra.put(46, (Object)MIXED_MARTIAL_ARTS);
        ra.put(2, (Object)ON_FOOT);
        ra.put(108, (Object)OTHER);
        ra.put(47, (Object)P90X);
        ra.put(48, (Object)PARAGLIDING);
        ra.put(49, (Object)PILATES);
        ra.put(50, (Object)POLO);
        ra.put(51, (Object)RACQUETBALL);
        ra.put(52, (Object)ROCK_CLIMBING);
        ra.put(53, (Object)ROWING);
        ra.put(54, (Object)ROWING_MACHINE);
        ra.put(55, (Object)RUGBY);
        ra.put(8, (Object)RUNNING);
        ra.put(56, (Object)RUNNING_JOGGING);
        ra.put(57, (Object)RUNNING_SAND);
        ra.put(58, (Object)RUNNING_TREADMILL);
        ra.put(59, (Object)SAILING);
        ra.put(60, (Object)SCUBA_DIVING);
        ra.put(61, (Object)SKATEBOARDING);
        ra.put(62, (Object)SKATING);
        ra.put(63, (Object)SKATING_CROSS);
        ra.put(105, (Object)SKATING_INDOOR);
        ra.put(64, (Object)SKATING_INLINE);
        ra.put(65, (Object)SKIING);
        ra.put(66, (Object)SKIING_BACK_COUNTRY);
        ra.put(67, (Object)SKIING_CROSS_COUNTRY);
        ra.put(68, (Object)SKIING_DOWNHILL);
        ra.put(69, (Object)SKIING_KITE);
        ra.put(70, (Object)SKIING_ROLLER);
        ra.put(71, (Object)SLEDDING);
        ra.put(72, (Object)SLEEP);
        ra.put(73, (Object)SNOWBOARDING);
        ra.put(74, (Object)SNOWMOBILE);
        ra.put(75, (Object)SNOWSHOEING);
        ra.put(76, (Object)SQUASH);
        ra.put(77, (Object)STAIR_CLIMBING);
        ra.put(78, (Object)STAIR_CLIMBING_MACHINE);
        ra.put(79, (Object)STANDUP_PADDLEBOARDING);
        ra.put(3, (Object)STILL);
        ra.put(80, (Object)STRENGTH_TRAINING);
        ra.put(81, (Object)SURFING);
        ra.put(82, (Object)SWIMMING);
        ra.put(83, (Object)SWIMMING_POOL);
        ra.put(84, (Object)SWIMMING_OPEN_WATER);
        ra.put(85, (Object)TABLE_TENNIS);
        ra.put(86, (Object)TEAM_SPORTS);
        ra.put(87, (Object)TENNIS);
        ra.put(5, (Object)TILTING);
        ra.put(88, (Object)TREADMILL);
        ra.put(4, (Object)UNKNOWN);
        ra.put(89, (Object)VOLLEYBALL);
        ra.put(90, (Object)VOLLEYBALL_BEACH);
        ra.put(91, (Object)VOLLEYBALL_INDOOR);
        ra.put(92, (Object)WAKEBOARDING);
        ra.put(7, (Object)WALKING);
        ra.put(93, (Object)WALKING_FITNESS);
        ra.put(94, (Object)WALKING_NORDIC);
        ra.put(95, (Object)WALKING_TREADMILL);
        ra.put(96, (Object)WATER_POLO);
        ra.put(97, (Object)WEIGHTLIFTING);
        ra.put(98, (Object)WHEELCHAIR);
        ra.put(99, (Object)WINDSURFING);
        ra.put(100, (Object)YOGA);
        ra.put(101, (Object)ZUMBA);
    }
}

