/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.e;
import com.google.android.gms.common.internal.i;
import com.google.android.gms.common.internal.j;
import com.google.android.gms.common.internal.m;
import java.util.ArrayList;

public abstract class d<T extends IInterface>
implements Api.a,
e.b {
    private final Context mContext;
    private final Looper nj;
    final Handler mHandler;
    private T pP;
    private final ArrayList<b<?>> pQ = new ArrayList();
    private e pR;
    private volatile int pS = 1;
    private final String[] kV;
    boolean pT = false;
    private final com.google.android.gms.common.internal.e ny;
    public static final String[] pU = new String[]{"service_esmobile", "service_googleme"};

    protected d(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = m.f(context);
        this.nj = m.a(looper, (Object)"Looper must not be null");
        this.ny = new com.google.android.gms.common.internal.e(context, looper, this);
        this.mHandler = new a(looper);
        this.b(stringArray);
        this.kV = stringArray;
        this.registerConnectionCallbacks(m.f(connectionCallbacks));
        this.registerConnectionFailedListener(m.f(onConnectionFailedListener));
    }

    @Deprecated
    protected d(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new f(onConnectionFailedListener), stringArray);
    }

    protected void b(String ... stringArray) {
    }

    protected abstract String getStartServiceAction();

    protected abstract String getServiceDescriptor();

    protected abstract T d(IBinder var1);

    private void C(int n2) {
        int n3 = this.pS;
        this.pS = n2;
        if (n3 != n2) {
            if (n2 == 3) {
                this.onConnected();
            } else if (n3 == 3 && n2 == 1) {
                this.onDisconnected();
            }
        }
    }

    protected void onConnected() {
    }

    protected void onDisconnected() {
    }

    @Override
    public void connect() {
        this.pT = true;
        this.C(2);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.C(1);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.pR != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.pP = null;
            com.google.android.gms.common.internal.f.n(this.mContext).b(this.getStartServiceAction(), this.pR);
        }
        this.pR = new e();
        boolean bl2 = com.google.android.gms.common.internal.f.n(this.mContext).a(this.getStartServiceAction(), this.pR);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.getStartServiceAction()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.pS == 3;
    }

    public boolean isConnecting() {
        return this.pS == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.pT = false;
        ArrayList<b<?>> arrayList = this.pQ;
        synchronized (arrayList) {
            int n2 = this.pQ.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pQ.get(i2).bP();
            }
            this.pQ.clear();
        }
        this.C(1);
        this.pP = null;
        if (this.pR != null) {
            com.google.android.gms.common.internal.f.n(this.mContext).b(this.getStartServiceAction(), this.pR);
            this.pR = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.nj;
    }

    public final String[] bL() {
        return this.kV;
    }

    protected final void e(IBinder iBinder) {
        try {
            j j2 = j.a.g(iBinder);
            this.a(j2, new d(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(j var1, d var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new g(n2, iBinder, bundle)));
    }

    protected final void w() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle bs() {
        return null;
    }

    public final T bM() {
        this.w();
        return this.pP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.pQ;
        synchronized (arrayList) {
            this.pQ.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean br() {
        return this.pT;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.ny.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.ny.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.ny.registerConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.ny.isConnectionCallbacksRegistered(new c(listener));
    }

    @Deprecated
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.ny.unregisterConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.ny.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.ny.isConnectionFailedListenerRegistered(listener);
    }

    @Deprecated
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.ny.unregisterConnectionFailedListener(listener);
    }

    public static final class d
    extends i.a {
        private d pY;

        public d(d d2) {
            this.pY = d2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            m.a("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.pY);
            this.pY.a(n2, iBinder, bundle);
            this.pY = null;
        }
    }

    protected final class g
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle qa;
        public final IBinder qb;

        public g(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.qb = iBinder;
            this.qa = bundle;
        }

        protected void a(Boolean bl2) {
            if (bl2 == null) {
                d.this.C(1);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.qb.getInterfaceDescriptor();
                        if (d.this.getServiceDescriptor().equals(string2)) {
                            d.this.pP = d.this.d(this.qb);
                            if (d.this.pP != null) {
                                d.this.C(3);
                                d.this.ny.y();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    com.google.android.gms.common.internal.f.n(d.this.mContext).b(d.this.getStartServiceAction(), d.this.pR);
                    d.this.pR = null;
                    d.this.C(1);
                    d.this.pP = null;
                    d.this.ny.b(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    d.this.C(1);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.qa != null) {
                        pendingIntent = (PendingIntent)this.qa.getParcelable("pendingIntent");
                    }
                    if (d.this.pR != null) {
                        com.google.android.gms.common.internal.f.n(d.this.mContext).b(d.this.getStartServiceAction(), d.this.pR);
                        d.this.pR = null;
                    }
                    d.this.C(1);
                    d.this.pP = null;
                    d.this.ny.b(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void bN() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.a((Boolean)object);
        }
    }

    public static final class f
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener pZ;

        public f(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.pZ = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.pZ.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof f) {
                return this.pZ.equals(((f)other).pZ);
            }
            return this.pZ.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks pX;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.pX = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.pX.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.pX.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.pX.equals(((c)other).pX);
            }
            return this.pX.equals(other);
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean pW;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.pW = false;
        }

        protected abstract void d(TListener var1);

        protected abstract void bN();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bO() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.pW) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.d(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.bN();
                    throw runtimeException;
                }
            } else {
                this.bN();
            }
            b2 = this;
            synchronized (b2) {
                this.pW = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.bP();
            ArrayList arrayList = d.this.pQ;
            synchronized (arrayList) {
                d.this.pQ.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bP() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !d.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.bN();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                d.this.ny.b(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                d.this.C(1);
                d.this.pP = null;
                d.this.ny.D((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !d.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.bN();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.bO();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            d.this.e(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            d.this.mHandler.sendMessage(d.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

