/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Parcel;
import android.view.View;
import com.google.android.gms.common.internal.ParcelableClientSettingsCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ClientSettings {
    private final ParcelableClientSettings pL;
    private final View nm;

    public ClientSettings(String accountName, Collection<String> scopes, int gravityForPopups, View viewForPopups, String realClientPackageName) {
        this.pL = new ParcelableClientSettings(accountName, scopes, gravityForPopups, realClientPackageName);
        this.nm = viewForPopups;
    }

    public String getAccountName() {
        return this.pL.getAccountName();
    }

    public String getAccountNameOrDefault() {
        return this.pL.getAccountNameOrDefault();
    }

    public int getGravityForPopups() {
        return this.pL.getGravityForPopups();
    }

    public List<String> getScopes() {
        return this.pL.getScopes();
    }

    public String[] getScopesArray() {
        return this.pL.getScopes().toArray(new String[0]);
    }

    public String getRealClientPackageName() {
        return this.pL.getRealClientPackageName();
    }

    public View getViewForPopups() {
        return this.nm;
    }

    public ParcelableClientSettings getParcelableClientSettings() {
        return this.pL;
    }

    public static final class ParcelableClientSettings
    implements SafeParcelable {
        public static final ParcelableClientSettingsCreator CREATOR = new ParcelableClientSettingsCreator();
        private final int nZ;
        private final String kK;
        private final List<String> nL = new ArrayList<String>();
        private final int nl;
        private final String nn;

        ParcelableClientSettings(int versionCode, String accountName, List<String> scopes, int gravityForPopups, String realClientPackageName) {
            this.nZ = versionCode;
            this.kK = accountName;
            this.nL.addAll(scopes);
            this.nl = gravityForPopups;
            this.nn = realClientPackageName;
        }

        public ParcelableClientSettings(String accountName, Collection<String> scopes, int gravityForPopups, String realClientPackageName) {
            this(3, accountName, new ArrayList<String>(scopes), gravityForPopups, realClientPackageName);
        }

        public String getAccountName() {
            return this.kK;
        }

        public String getAccountNameOrDefault() {
            return this.kK != null ? this.kK : "<<default account>>";
        }

        public int getGravityForPopups() {
            return this.nl;
        }

        public String getRealClientPackageName() {
            return this.nn;
        }

        public List<String> getScopes() {
            return new ArrayList<String>(this.nL);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            ParcelableClientSettingsCreator.a(this, out, flags);
        }

        public int getVersionCode() {
            return this.nZ;
        }
    }
}

