/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.c;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataHolder
implements SafeParcelable {
    public static final c CREATOR = new c();
    private final int nZ;
    private final String[] os;
    Bundle ot;
    private final CursorWindow[] ou;
    private final int mg;
    private final Bundle ov;
    int[] ow;
    int ox;
    boolean mClosed = false;
    private Object oy;
    private boolean oz = true;
    private static final a oA = new a(new String[0], null){};

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.nZ = versionCode;
        this.os = columns;
        this.ou = windows;
        this.mg = statusCode;
        this.ov = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.nZ = 1;
        this.os = m.f(columns);
        this.ou = m.f(windows);
        this.mg = statusCode;
        this.ov = metadata;
        this.bx();
    }

    public void b(Object object) {
        this.oy = object;
    }

    private DataHolder(a builder, int statusCode, Bundle metadata) {
        this(builder.os, DataHolder.a(builder, -1), statusCode, metadata);
    }

    public void bx() {
        int n2;
        this.ot = new Bundle();
        for (n2 = 0; n2 < this.os.length; ++n2) {
            this.ot.putInt(this.os[n2], n2);
        }
        this.ow = new int[this.ou.length];
        n2 = 0;
        for (int i2 = 0; i2 < this.ou.length; ++i2) {
            this.ow[i2] = n2;
            int n3 = this.ou[i2].getStartPosition();
            int n4 = n2 - n3;
            n2 += this.ou[i2].getNumRows() - n4;
        }
        this.ox = n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        c.a(this, dest, flags);
    }

    int getVersionCode() {
        return this.nZ;
    }

    String[] by() {
        return this.os;
    }

    CursorWindow[] bz() {
        return this.ou;
    }

    public int getStatusCode() {
        return this.mg;
    }

    public Bundle bw() {
        return this.ov;
    }

    private static CursorWindow[] a(a a2, int n2) {
        if (a2.os.length == 0) {
            return new CursorWindow[0];
        }
        List list = n2 < 0 || n2 >= a2.oB.size() ? a2.oB : a2.oB.subList(0, n2);
        int n3 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(a2.os.length);
        try {
            int n4 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i2 + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i2);
                    cursorWindow.setNumColumns(a2.os.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                    n4 = 0;
                }
                Map map = (Map)list.get(i2);
                boolean bl2 = true;
                for (int i3 = 0; i3 < a2.os.length && bl2; ++i3) {
                    String string2 = a2.os[i3];
                    Object v2 = map.get(string2);
                    if (v2 == null) {
                        bl2 = cursorWindow.putNull(n4, i3);
                        continue;
                    }
                    if (v2 instanceof String) {
                        bl2 = cursorWindow.putString((String)v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v2).longValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v2).intValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Boolean) {
                        boolean bl3 = (Boolean)v2;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, n4, i3);
                        continue;
                    }
                    if (v2 instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v2).doubleValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v2).floatValue(), n4, i3);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v2);
                }
                if (!bl2) {
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i2 + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setNumColumns(a2.os.length);
                    arrayList.add(cursorWindow);
                    n4 = 0;
                    --i2;
                    continue;
                }
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i4 = 0; i4 < n5; ++i4) {
                ((CursorWindow)arrayList.get(i4)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void d(String string2, int n2) {
        if (this.ot == null || !this.ot.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n2 < 0 || n2 >= this.ox) {
            throw new CursorIndexOutOfBoundsException(n2, this.ox);
        }
    }

    public int a(String string2, int n2, int n3) {
        this.d(string2, n2);
        return this.ou[n3].getInt(n2, this.ot.getInt(string2));
    }

    public String b(String string2, int n2, int n3) {
        this.d(string2, n2);
        return this.ou[n3].getString(n2, this.ot.getInt(string2));
    }

    public byte[] c(String string2, int n2, int n3) {
        this.d(string2, n2);
        return this.ou[n3].getBlob(n2, this.ot.getInt(string2));
    }

    public int getCount() {
        return this.ox;
    }

    public int u(int n2) {
        int n3;
        m.f(n2 >= 0 && n2 < this.ox);
        for (n3 = 0; n3 < this.ow.length; ++n3) {
            if (n2 >= this.ow[n3]) continue;
            --n3;
            break;
        }
        if (n3 == this.ow.length) {
            --n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i2 = 0; i2 < this.ou.length; ++i2) {
                    this.ou[i2].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.oz && this.ou.length > 0 && !this.isClosed()) {
                String string2 = this.oy == null ? "internal object: " + this.toString() : this.oy.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static DataHolder v(int n2) {
        return DataHolder.a(n2, null);
    }

    public static DataHolder a(int n2, Bundle bundle) {
        return new DataHolder(oA, n2, bundle);
    }

    public static class a {
        private final String[] os;
        private final ArrayList<HashMap<String, Object>> oB;
        private final String oC;
        private final HashMap<Object, Integer> oD;
        private boolean oE;
        private String oF;

        private a(String[] stringArray, String string2) {
            this.os = m.f(stringArray);
            this.oB = new ArrayList();
            this.oC = string2;
            this.oD = new HashMap();
            this.oE = false;
            this.oF = null;
        }
    }
}

