/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

public final class Status
implements Result,
SafeParcelable {
    public static final Status nU = new Status(0);
    public static final Status nV = new Status(14);
    public static final Status nW = new Status(8);
    public static final Status nX = new Status(15);
    public static final Status nY = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int nZ;
    private final int mg;
    private final String oa;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.nZ = versionCode;
        this.mg = statusCode;
        this.oa = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.oa;
    }

    int getVersionCode() {
        return this.nZ;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.mg <= 0;
    }

    public boolean isCanceled() {
        return this.mg == 16;
    }

    public boolean isInterrupted() {
        return this.mg == 14;
    }

    public int getStatusCode() {
        return this.mg;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return l.hashCode(this.nZ, this.mg, this.oa, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.nZ == status.nZ && this.mg == status.mg && l.equal(this.oa, status.oa) && l.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String aZ() {
        if (this.oa != null) {
            return this.oa;
        }
        return CommonStatusCodes.getStatusCodeString(this.mg);
    }

    public String toString() {
        return l.e(this).a("statusCode", this.aZ()).a("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

