/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.internal.h;
import com.google.android.gms.common.internal.m;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BaseImplementation {
    static void a(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"GoogleApi", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public static final int CALLBACK_ON_COMPLETE = 1;
        public static final int CALLBACK_ON_TIMEOUT = 2;

        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void sendTimeoutResultCallback(AbstractPendingResult<R> pendingResult, long millis) {
            this.sendMessageDelayed(this.obtainMessage(2, pendingResult), millis);
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.bj();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                BaseImplementation.a(result);
                throw runtimeException;
            }
        }
    }

    public static abstract class AbstractPendingResult<R extends Result>
    implements b<R>,
    PendingResult<R> {
        private final Object mS = new Object();
        protected CallbackHandler<R> mHandler;
        private final CountDownLatch mT = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> mU = new ArrayList();
        private ResultCallback<R> mV;
        private volatile R mW;
        private volatile boolean mX;
        private boolean mY;
        private boolean mZ;
        private h na;

        AbstractPendingResult() {
        }

        public AbstractPendingResult(Looper looper) {
            this.mHandler = new CallbackHandler(looper);
        }

        public AbstractPendingResult(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }

        protected abstract R a(Status var1);

        public final boolean isReady() {
            return this.mT.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R bg() {
            Object object = this.mS;
            synchronized (object) {
                m.a(!this.mX, (Object)"Result has already been consumed.");
                m.a(this.isReady(), (Object)"Result is not ready.");
                R r2 = this.mW;
                this.bh();
                return r2;
            }
        }

        @Override
        public final R await() {
            m.a(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
            m.a(!this.mX, (Object)"Result has already been consumed");
            try {
                this.mT.await();
            }
            catch (InterruptedException interruptedException) {
                this.bi();
            }
            m.a(this.isReady(), (Object)"Result is not ready.");
            return this.bg();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            m.a(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
            m.a(!this.mX, (Object)"Result has already been consumed.");
            try {
                boolean bl2 = this.mT.await(time, units);
                if (!bl2) {
                    this.bj();
                }
            }
            catch (InterruptedException interruptedException) {
                this.bi();
            }
            m.a(this.isReady(), (Object)"Result is not ready.");
            return this.bg();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            m.a(!this.mX, (Object)"Result has already been consumed.");
            Object object = this.mS;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.bg());
                } else {
                    this.mV = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            m.a(!this.mX, (Object)"Result has already been consumed.");
            m.a(this.mHandler != null, (Object)"CallbackHandler has not been set before calling setResultCallback.");
            Object object = this.mS;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.bg());
                } else {
                    this.mV = callback;
                    this.mHandler.sendTimeoutResultCallback(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            m.a(!this.mX, (Object)"Result has already been consumed.");
            Object object = this.mS;
            synchronized (object) {
                if (this.isReady()) {
                    a2.c(this.mW.getStatus());
                } else {
                    this.mU.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.mS;
            synchronized (object) {
                if (this.mY || this.mX) {
                    return;
                }
                if (this.na != null) {
                    try {
                        this.na.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                BaseImplementation.a(this.mW);
                this.mV = null;
                this.mY = true;
                this.c(this.a(Status.nY));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.mS;
            synchronized (object) {
                return this.mY;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void b(R r2) {
            Object object = this.mS;
            synchronized (object) {
                if (this.mZ || this.mY) {
                    BaseImplementation.a(r2);
                    return;
                }
                m.a(!this.isReady(), (Object)"Results have already been set");
                m.a(!this.mX, (Object)"Result has already been consumed");
                this.c(r2);
            }
        }

        protected void bh() {
            this.mX = true;
            this.mW = null;
            this.mV = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bi() {
            Object object = this.mS;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.a(Status.nV));
                    this.mZ = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bj() {
            Object object = this.mS;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.a(Status.nX));
                    this.mZ = true;
                }
            }
        }

        private void c(R r2) {
            this.mW = r2;
            this.na = null;
            this.mT.countDown();
            Status status = this.mW.getStatus();
            if (this.mV != null) {
                this.mHandler.removeTimeoutMessages();
                if (!this.mY) {
                    this.mHandler.sendResultCallback(this.mV, this.bg());
                }
            }
            for (PendingResult.a a2 : this.mU) {
                a2.c(status);
            }
            this.mU.clear();
        }

        @Override
        protected void a(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.b((Result)object);
        }
    }

    public static abstract class a<R extends Result, A extends Api.a>
    extends AbstractPendingResult<R>
    implements a.c<A> {
        private final Api.c<A> mQ;
        private a.a nb;

        protected a(Api.c<A> c2) {
            this.mQ = m.f(c2);
        }

        @Override
        public final Api.c<A> bf() {
            return this.mQ;
        }

        @Override
        public final void a(A a2) throws DeadObjectException {
            if (this.mHandler == null) {
                this.a((A)((Object)new CallbackHandler(a2.getLooper())));
            }
            try {
                this.b(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void b(Status status) {
            m.b(!status.isSuccess(), (Object)"Failed result must not be success");
            this.b((A)this.a(status));
        }

        @Override
        public void a(a.a a2) {
            this.nb = a2;
        }

        @Override
        public int bk() {
            return 0;
        }

        @Override
        protected abstract void b(A var1) throws RemoteException;

        @Override
        protected void bh() {
            super.bh();
            if (this.nb != null) {
                this.nb.b(this);
                this.nb = null;
            }
        }

        @Override
        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.b(status);
        }
    }

    public static interface b<R> {
        public void a(R var1);
    }
}

