/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ag;
import com.google.android.gms.analytics.d;
import com.google.android.gms.analytics.e;
import com.google.android.gms.analytics.m;
import com.google.android.gms.analytics.o;
import com.google.android.gms.analytics.w;
import com.google.android.gms.analytics.x;
import com.google.android.gms.analytics.z;
import com.google.android.gms.internal.g;
import com.google.android.gms.internal.r;
import com.google.android.gms.internal.s;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class ab
implements d {
    private static final String jR = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private final a jS;
    private volatile m jT;
    private final e he;
    private final Context mContext;
    private final String jU;
    private aa jV;
    private long jW;
    private final int jX;
    private r hw;

    ab(e e2, Context context) {
        this(e2, context, "google_analytics_v4.db", 2000);
    }

    ab(e e2, Context context, String string2, int n2) {
        this.mContext = context.getApplicationContext();
        this.jU = string2;
        this.he = e2;
        this.hw = s.bU();
        this.jS = new a(this.mContext, this.jU);
        this.jT = new ag((HttpClient)new DefaultHttpClient(), this.mContext);
        this.jW = 0L;
        this.jX = n2;
    }

    @Override
    public void a(long l2) {
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for clearHits");
        if (sQLiteDatabase != null) {
            if (l2 == 0L) {
                sQLiteDatabase.delete("hits2", null, null);
            } else {
                String[] stringArray = new String[]{Long.valueOf(l2).toString()};
                sQLiteDatabase.delete("hits2", "hit_app_id = ?", stringArray);
            }
            this.he.b(this.aC() == 0);
        }
    }

    @Override
    public void a(Map<String, String> map, long l2, String string2, Collection<g> collection) {
        this.aB();
        this.aA();
        this.a(map, collection);
        this.a(map, l2, string2);
    }

    private void a(Map<String, String> map, Collection<g> collection) {
        String string2 = "&_v".substring(1);
        if (collection != null) {
            for (g g2 : collection) {
                if (!"appendVersion".equals(g2.getId())) continue;
                map.put(string2, g2.getValue());
                break;
            }
        }
    }

    private void aA() {
        int n2 = this.aC() - this.jX + 1;
        if (n2 > 0) {
            List<String> list = this.j(n2);
            z.o("Store full, deleting " + list.size() + " hits to make room.");
            this.a(list.toArray(new String[0]));
        }
    }

    private void a(Map<String, String> map, long l2, String string2) {
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", ab.g(map));
        contentValues.put("hit_time", Long.valueOf(l2));
        long l3 = 0L;
        if (map.containsKey("AppUID")) {
            try {
                l3 = Long.parseLong(map.get("AppUID"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        contentValues.put("hit_app_id", Long.valueOf(l3));
        if (string2 == null) {
            string2 = "http://www.google-analytics.com/collect";
        }
        if (string2.length() == 0) {
            z.p("Empty path: not sending hit");
            return;
        }
        contentValues.put("hit_url", string2);
        try {
            sQLiteDatabase.insert("hits2", null, contentValues);
            this.he.b(false);
        }
        catch (SQLiteException sQLiteException) {
            z.p("Error storing hit");
        }
    }

    static String g(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(x.encode(entry.getKey()) + "=" + x.encode(entry.getValue()));
        }
        return TextUtils.join((CharSequence)"&", arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> j(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            z.p("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<w> k(int n2) {
        ArrayList<w> arrayList = new ArrayList<w>();
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    w w2 = new w(null, cursor.getLong(0), cursor.getLong(1));
                    arrayList.add(w2);
                } while (cursor.moveToNext());
            }
        }
        int n3 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_string", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((w)arrayList.get(n3)).k(cursor.getString(1));
                        ((w)arrayList.get(n3)).l(cursor.getString(2));
                    } else {
                        z.p(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((w)arrayList.get(n3)).au()));
                    }
                    ++n3;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            z.p("Error in peekHits fetching hitString: " + sQLiteException.getMessage());
            ArrayList<w> arrayList2 = new ArrayList<w>();
            boolean bl2 = false;
            for (w w3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)w3.at())) {
                    if (bl2) break;
                    bl2 = true;
                }
                arrayList2.add(w3);
            }
            ArrayList<w> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int aB() {
        long l2 = this.hw.currentTimeMillis();
        if (l2 <= this.jW + 86400000L) {
            return 0;
        }
        this.jW = l2;
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l3 = this.hw.currentTimeMillis() - 2592000000L;
        int n2 = sQLiteDatabase.delete("hits2", "HIT_TIME < ?", new String[]{Long.toString(l3)});
        this.he.b(this.aC() == 0);
        return n2;
    }

    @Deprecated
    void a(Collection<w> collection) {
        if (collection == null || collection.isEmpty()) {
            z.p("Empty/Null collection passed to deleteHits.");
            return;
        }
        String[] stringArray = new String[collection.size()];
        int n2 = 0;
        for (w w2 : collection) {
            stringArray[n2++] = String.valueOf(w2.au());
        }
        this.a(stringArray);
    }

    void a(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            z.p("Empty hitIds passed to deleteHits.");
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string2 = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("hits2", string2, stringArray);
            this.he.b(this.aC() == 0);
        }
        catch (SQLiteException sQLiteException) {
            z.p("Error deleting hits " + TextUtils.join((CharSequence)",", (Object[])stringArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int aC() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from hits2", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        return n2;
    }

    @Override
    public void dispatch() {
        int n2;
        z.o("Dispatch running...");
        if (!this.jT.K()) {
            return;
        }
        List<w> list = this.k(40);
        if (list.isEmpty()) {
            z.o("...nothing to dispatch");
            this.he.b(true);
            return;
        }
        if (this.jV == null) {
            this.jV = new aa("_t=dispatch&_v=ma4.0.3", true);
        }
        boolean bl2 = (n2 = this.aC()) <= list.size();
        int n3 = this.jT.a(list, this.jV, bl2);
        z.o("sent " + n3 + " of " + list.size() + " hits");
        this.a(list.subList(0, Math.min(n3, list.size())));
        if (n3 == list.size() && this.aC() > 0) {
            GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        } else {
            this.jV = null;
        }
    }

    @Override
    public m z() {
        return this.jT;
    }

    private SQLiteDatabase q(String string2) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.jS.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            z.p(string2);
            return null;
        }
        return sQLiteDatabase;
    }

    class a
    extends SQLiteOpenHelper {
        private boolean jY;
        private long jZ;

        a(Context context, String string2) {
            super(context, string2, null, 1);
            this.jZ = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string2, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string2}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.jY && this.jZ + 3600000L > ab.this.hw.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.jY = true;
            this.jZ = ab.this.hw.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                ab.this.mContext.getDatabasePath(ab.this.jU).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.jY = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.a("hits2", db2)) {
                db2.execSQL(jR);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            boolean bl2;
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM hits2 WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_string") && hashSet.remove("hit_time"))) {
                throw new SQLiteException("Database column missing");
            }
            boolean bl3 = bl2 = !hashSet.remove("hit_app_id");
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
            if (bl2) {
                sQLiteDatabase.execSQL("ALTER TABLE hits2 ADD COLUMN hit_app_id");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            o.h(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }
}

