/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.ac;
import com.google.android.gms.analytics.ad;
import com.google.android.gms.analytics.ai;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.t;
import com.google.android.gms.analytics.y;
import com.google.android.gms.analytics.z;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.internal.r;
import com.google.android.gms.internal.s;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker {
    private final TrackerHandler kg;
    private Context mContext;
    private final Map<String, String> kh = new HashMap<String, String>();
    private ac ki;
    private final h kj;
    private final ad kk;
    private final g kl;
    private boolean km;
    private a kn;
    private ai ko;
    private ExceptionReporter kp;

    Tracker(String trackingId, TrackerHandler handler, Context context) {
        this(trackingId, handler, h.D(), ad.aE(), g.C(), new y("tracking"), context);
    }

    Tracker(String trackingId, TrackerHandler handler, h clientIdDefaultProvider, ad screenResolutionDefaultProvider, g appFieldsDefaultProvider, ac rateLimiter, Context context) {
        this.kg = handler;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        if (trackingId != null) {
            this.kh.put("&tid", trackingId);
        }
        this.kh.put("useSecure", "1");
        this.kj = clientIdDefaultProvider;
        this.kk = screenResolutionDefaultProvider;
        this.kl = appFieldsDefaultProvider;
        this.kh.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.ki = rateLimiter;
        this.kn = new a();
        this.enableAdvertisingIdCollection(false);
    }

    void a(ai ai2) {
        String string2;
        z.o("Loading Tracker config values.");
        this.ko = ai2;
        if (this.ko.aN()) {
            string2 = this.ko.aO();
            this.set("&tid", string2);
            z.o("[Tracker] trackingId loaded: " + string2);
        }
        if (this.ko.aP()) {
            string2 = Double.toString(this.ko.aQ());
            this.set("&sf", string2);
            z.o("[Tracker] sample frequency loaded: " + string2);
        }
        if (this.ko.aR()) {
            this.setSessionTimeout(this.ko.getSessionTimeout());
            z.o("[Tracker] session timeout loaded: " + this.aH());
        }
        if (this.ko.aS()) {
            this.enableAutoActivityTracking(this.ko.aT());
            z.o("[Tracker] auto activity tracking loaded: " + this.aI());
        }
        if (this.ko.aU()) {
            if (this.ko.aV()) {
                this.set("&aip", "1");
                z.o("[Tracker] anonymize ip loaded: true");
            }
            z.o("[Tracker] anonymize ip loaded: false");
        }
        this.enableExceptionReporting(this.ko.aW());
    }

    public void enableExceptionReporting(boolean enabled) {
        if (this.km == enabled) {
            return;
        }
        this.km = enabled;
        if (enabled) {
            this.kp = new ExceptionReporter(this, Thread.getDefaultUncaughtExceptionHandler(), this.mContext);
            Thread.setDefaultUncaughtExceptionHandler(this.kp);
            z.o("Uncaught exceptions will be reported to Google Analytics.");
        } else {
            if (this.kp != null) {
                Thread.setDefaultUncaughtExceptionHandler(this.kp.L());
            } else {
                Thread.setDefaultUncaughtExceptionHandler(null);
            }
            z.o("Uncaught exceptions will not be reported to Google Analytics.");
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.kn.setSessionTimeout(sessionTimeout * 1000L);
    }

    long aH() {
        return this.kn.aH();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.kn.enableAutoActivityTracking(enabled);
    }

    boolean aI() {
        return this.kn.aI();
    }

    public void send(Map<String, String> params) {
        String string2;
        t.ad().a(t.a.ij);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.kh);
        if (params != null) {
            hashMap.putAll(params);
        }
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            z.p(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = (String)hashMap.get("&t")))) {
            z.p(String.format("Missing hit type (%s) parameter.", "&t"));
            string2 = "";
        }
        if (this.kn.aJ()) {
            hashMap.put("&sc", "start");
        }
        if ("screenview".equals(string2 = string2.toLowerCase()) || "pageview".equals(string2) || "appview".equals(string2) || TextUtils.isEmpty((CharSequence)string2)) {
            int n2 = Integer.parseInt(this.kh.get("&a"));
            n2 = ++n2 >= Integer.MAX_VALUE ? 1 : n2;
            this.kh.put("&a", Integer.toString(n2));
        }
        if (!(string2.equals("transaction") || string2.equals("item") || this.ki.ax())) {
            z.p("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.kg.a(hashMap);
        }
    }

    public String get(String key) {
        t.ad().a(t.a.ih);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.kh.containsKey(key)) {
            return this.kh.get(key);
        }
        if (key.equals("&ul")) {
            return aj.a(Locale.getDefault());
        }
        if (this.kj != null && this.kj.d(key)) {
            return this.kj.getValue(key);
        }
        if (this.kk != null && this.kk.d(key)) {
            return this.kk.getValue(key);
        }
        if (this.kl != null && this.kl.d(key)) {
            return this.kl.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        m.a(key, (Object)"Key should be non-null");
        t.ad().a(t.a.ii);
        this.kh.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toHexString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", aj.e(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            z.p("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", aj.e(anonymize));
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.kh.put("&ate", null);
            this.kh.put("&adid", null);
        } else {
            if (this.kh.containsKey("&ate")) {
                this.kh.remove("&ate");
            }
            if (this.kh.containsKey("&adid")) {
                this.kh.remove("&adid");
            }
        }
    }

    private class a
    implements GoogleAnalytics.a {
        private boolean kq = false;
        private int kr = 0;
        private long ks = -1L;
        private boolean kt = false;
        private long ku;
        private r hw = s.bU();

        public void setSessionTimeout(long sessionTimeout) {
            this.ks = sessionTimeout;
            this.aK();
        }

        public long aH() {
            return this.ks;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.kq = enabled;
            this.aK();
        }

        public boolean aI() {
            return this.kq;
        }

        public boolean aJ() {
            boolean bl2 = this.kt;
            this.kt = false;
            return bl2;
        }

        private void aK() {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.ar();
            if (googleAnalytics == null) {
                z.m("GoogleAnalytics isn't initialized for the Tracker!");
                return;
            }
            if (this.ks >= 0L || this.kq) {
                googleAnalytics.a(Tracker.this.kn);
            } else {
                googleAnalytics.b(Tracker.this.kn);
            }
        }

        @Override
        public void c(Activity activity) {
            t.ad().a(t.a.jg);
            if (this.kr == 0 && this.aL()) {
                this.kt = true;
            }
            ++this.kr;
            if (this.kq) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                t.ad().d(true);
                Tracker.this.set("&cd", Tracker.this.ko != null ? Tracker.this.ko.e(activity) : activity.getClass().getCanonicalName());
                Tracker.this.send(hashMap);
                t.ad().d(false);
            }
        }

        @Override
        public void d(Activity activity) {
            t.ad().a(t.a.jh);
            --this.kr;
            this.kr = Math.max(0, this.kr);
            if (this.kr == 0) {
                this.ku = this.hw.elapsedRealtime();
            }
        }

        boolean aL() {
            return this.hw.elapsedRealtime() >= this.ku + Math.max(1000L, this.ks);
        }
    }
}

