/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.c;
import com.google.android.gms.common.internal.i;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.ab;
import com.google.android.gms.wearable.internal.ad;
import com.google.android.gms.wearable.internal.ae;
import com.google.android.gms.wearable.internal.af;
import com.google.android.gms.wearable.internal.ag;
import com.google.android.gms.wearable.internal.aj;
import com.google.android.gms.wearable.internal.ao;
import com.google.android.gms.wearable.internal.aq;
import com.google.android.gms.wearable.internal.as;
import com.google.android.gms.wearable.internal.ax;
import com.google.android.gms.wearable.internal.b;
import com.google.android.gms.wearable.internal.f;
import com.google.android.gms.wearable.internal.p;
import com.google.android.gms.wearable.internal.v;
import com.google.android.gms.wearable.internal.x;
import com.google.android.gms.wearable.internal.z;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class aw
extends c<af> {
    private final ExecutorService Dr = Executors.newCachedThreadPool();
    private final HashMap<DataApi.DataListener, ax> Gs = new HashMap();
    private final HashMap<MessageApi.MessageListener, ax> Gt = new HashMap();
    private final HashMap<NodeApi.NodeListener, ax> Gu = new HashMap();

    public aw(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, new String[0]);
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.wearable.BIND";
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected af ar(IBinder iBinder) {
        return af.a.aq(iBinder);
    }

    @Override
    protected void a(i i2, c.d d2) throws RemoteException {
        i2.e(d2, 6111500, this.getContext().getPackageName());
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)("onPostInitHandler: statusCode " + n2));
        }
        if (n2 == 0) {
            try {
                com.google.android.gms.wearable.internal.a a2 = new com.google.android.gms.wearable.internal.a(){

                    @Override
                    public void t(Status status) {
                    }
                };
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.d((String)"WearableClient", (String)("onPostInitHandler: service " + iBinder));
                }
                af af2 = af.a.aq(iBinder);
                for (Map.Entry<DataApi.DataListener, ax> entry : this.Gs.entrySet()) {
                    if (Log.isLoggable((String)"WearableClient", (int)2)) {
                        Log.d((String)"WearableClient", (String)("onPostInitHandler: adding Data listener " + entry.getValue()));
                    }
                    af2.a((ad)a2, new b(entry.getValue()));
                }
                for (Map.Entry<Object, ax> entry : this.Gt.entrySet()) {
                    if (Log.isLoggable((String)"WearableClient", (int)2)) {
                        Log.d((String)"WearableClient", (String)("onPostInitHandler: adding Message listener " + entry.getValue()));
                    }
                    af2.a((ad)a2, new b(entry.getValue()));
                }
                for (Map.Entry<Object, ax> entry : this.Gu.entrySet()) {
                    if (Log.isLoggable((String)"WearableClient", (int)2)) {
                        Log.d((String)"WearableClient", (String)("onPostInitHandler: adding Node listener " + entry.getValue()));
                    }
                    af2.a((ad)a2, new b(entry.getValue()));
                }
            }
            catch (RemoteException remoteException) {
                Log.d((String)"WearableClient", (String)"WearableClientImpl.onPostInitHandler: error while adding listener", (Throwable)remoteException);
            }
        }
        Log.d((String)"WearableClient", (String)"WearableClientImpl.onPostInitHandler: done");
        super.a(n2, iBinder, bundle);
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.Gs.clear();
        this.Gt.clear();
        this.Gu.clear();
    }

    public void a(BaseImplementation.b<DataApi.DataItemResult> b2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Asset asset = entry22.getValue();
            if (asset.getData() != null || asset.getDigest() != null || asset.getFd() != null || asset.getUri() != null) continue;
            throw new IllegalArgumentException("Put for " + putDataRequest.getUri() + " contains invalid asset: " + asset);
        }
        PutDataRequest putDataRequest2 = PutDataRequest.d(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            ParcelFileDescriptor[] parcelFileDescriptorArray;
            Asset asset = (Asset)entry3.getValue();
            if (asset.getData() == null) {
                putDataRequest2.putAsset((String)entry3.getKey(), (Asset)entry3.getValue());
                continue;
            }
            try {
                parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to create ParcelFileDescriptor for asset in request: " + putDataRequest, iOException);
            }
            if (Log.isLoggable((String)"WearableClient", (int)3)) {
                Log.d((String)"WearableClient", (String)("processAssets: replacing data with FD in asset: " + asset + " read:" + parcelFileDescriptorArray[0] + " write:" + parcelFileDescriptorArray[1]));
            }
            putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptorArray[0]));
            FutureTask<Boolean> futureTask = this.a(parcelFileDescriptorArray[1], asset.getData());
            entry22.add(futureTask);
            this.Dr.submit(futureTask);
        }
        try {
            ((af)this.bL()).a((ad)new a(b2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Unable to putDataItem: " + putDataRequest, nullPointerException);
        }
    }

    private FutureTask<Boolean> a(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean gC() {
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: writing data to FD : " + parcelFileDescriptor));
                }
                ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    autoCloseOutputStream.write(byArray);
                    autoCloseOutputStream.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        Log.d((String)"WearableClient", (String)("processAssets: wrote data: " + parcelFileDescriptor));
                    }
                    Boolean bl2 = true;
                    return bl2;
                }
                catch (IOException iOException) {
                    Log.w((String)"WearableClient", (String)("processAssets: writing data failed: " + parcelFileDescriptor));
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            Log.d((String)"WearableClient", (String)("processAssets: closing: " + parcelFileDescriptor));
                        }
                        autoCloseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.gC();
            }
        });
    }

    public void a(final BaseImplementation.b<DataApi.DataItemResult> b2, Uri uri) throws RemoteException {
        ((af)this.bL()).a((ad)new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(x x2) {
                b2.a(new f.a(new Status(x2.statusCode), x2.FZ));
            }
        }, uri);
    }

    @Override
    public void a(final BaseImplementation.b<DataItemBuffer> b2) throws RemoteException {
        ((af)this.bL()).b(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void e(DataHolder dataHolder) {
                b2.a(new DataItemBuffer(dataHolder));
            }
        });
    }

    public void b(final BaseImplementation.b<DataItemBuffer> b2, Uri uri) throws RemoteException {
        ((af)this.bL()).b((ad)new com.google.android.gms.wearable.internal.a(){

            @Override
            public void e(DataHolder dataHolder) {
                b2.a(new DataItemBuffer(dataHolder));
            }
        }, uri);
    }

    public void c(final BaseImplementation.b<DataApi.DeleteDataItemsResult> b2, Uri uri) throws RemoteException {
        ((af)this.bL()).c((ad)new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(p p2) {
                b2.a(new f.b(new Status(p2.statusCode), p2.FV));
            }
        }, uri);
    }

    public void a(final BaseImplementation.b<MessageApi.SendMessageResult> b2, String string2, String string3, byte[] byArray) throws RemoteException {
        ((af)this.bL()).a(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(as as2) {
                b2.a(new ag.a(new Status(as2.statusCode), as2.Gq));
            }
        }, string2, string3, byArray);
    }

    public void a(final BaseImplementation.b<DataApi.GetFdForAssetResult> b2, Asset asset) throws RemoteException {
        ((af)this.bL()).a((ad)new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(z z2) {
                b2.a(new f.c(new Status(z2.statusCode), z2.Ga));
            }
        }, asset);
    }

    public void a(BaseImplementation.b<DataApi.GetFdForAssetResult> b2, DataItemAsset dataItemAsset) throws RemoteException {
        this.a(b2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void b(final BaseImplementation.b<NodeApi.GetLocalNodeResult> b2) throws RemoteException {
        ((af)this.bL()).c(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(ab ab2) {
                b2.a(new aj.b(new Status(ab2.statusCode), ab2.Gb));
            }
        });
    }

    public void c(final BaseImplementation.b<NodeApi.GetConnectedNodesResult> b2) throws RemoteException {
        ((af)this.bL()).d(new com.google.android.gms.wearable.internal.a(){

            @Override
            public void a(v v2) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                arrayList.addAll(v2.FY);
                b2.a(new aj.a(new Status(v2.statusCode), arrayList));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(final BaseImplementation.b<Status> b2, final DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) throws RemoteException {
        ax ax2 = ax.a(dataListener, intentFilterArray);
        HashMap<DataApi.DataListener, ax> hashMap = this.Gs;
        synchronized (hashMap) {
            if (this.Gs.get(dataListener) != null) {
                b2.a(new Status(4001));
                return;
            }
            this.Gs.put(dataListener, ax2);
        }
        ((af)this.bL()).a((ad)new com.google.android.gms.wearable.internal.a(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void t(Status status) {
                if (!status.isSuccess()) {
                    HashMap hashMap = aw.this.Gs;
                    synchronized (hashMap) {
                        aw.this.Gs.remove(dataListener);
                    }
                }
                b2.a(status);
            }
        }, new b(ax2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(final BaseImplementation.b<Status> b2, final MessageApi.MessageListener messageListener, IntentFilter[] intentFilterArray) throws RemoteException {
        ax ax2 = ax.a(messageListener, intentFilterArray);
        HashMap<MessageApi.MessageListener, ax> hashMap = this.Gt;
        synchronized (hashMap) {
            if (this.Gt.get(messageListener) != null) {
                b2.a(new Status(4001));
                return;
            }
            this.Gt.put(messageListener, ax2);
        }
        ((af)this.bL()).a((ad)new com.google.android.gms.wearable.internal.a(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void t(Status status) {
                if (!status.isSuccess()) {
                    HashMap hashMap = aw.this.Gt;
                    synchronized (hashMap) {
                        aw.this.Gt.remove(messageListener);
                    }
                }
                b2.a(status);
            }
        }, new b(ax2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(final BaseImplementation.b<Status> b2, final NodeApi.NodeListener nodeListener) throws RemoteException, RemoteException {
        ax ax2 = ax.a(nodeListener);
        HashMap<NodeApi.NodeListener, ax> hashMap = this.Gu;
        synchronized (hashMap) {
            if (this.Gu.get(nodeListener) != null) {
                b2.a(new Status(4001));
                return;
            }
            this.Gu.put(nodeListener, ax2);
        }
        ((af)this.bL()).a((ad)new com.google.android.gms.wearable.internal.a(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void t(Status status) {
                if (!status.isSuccess()) {
                    HashMap hashMap = aw.this.Gu;
                    synchronized (hashMap) {
                        aw.this.Gu.remove(nodeListener);
                    }
                }
                b2.a(status);
            }
        }, new b(ax2));
    }

    public void a(final BaseImplementation.b<Status> b2, ae ae2) throws RemoteException {
        ((af)this.bL()).a((ad)new com.google.android.gms.wearable.internal.a(){

            @Override
            public void t(Status status) {
                b2.a(status);
            }
        }, new aq(ae2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(BaseImplementation.b<Status> b2, DataApi.DataListener dataListener) throws RemoteException {
        ae ae2;
        HashMap<DataApi.DataListener, ax> hashMap = this.Gs;
        synchronized (hashMap) {
            ae2 = this.Gs.remove(dataListener);
        }
        if (ae2 == null) {
            b2.a(new Status(4002));
        } else {
            this.a(b2, ae2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(BaseImplementation.b<Status> b2, MessageApi.MessageListener messageListener) throws RemoteException {
        HashMap<MessageApi.MessageListener, ax> hashMap = this.Gt;
        synchronized (hashMap) {
            ae ae2 = this.Gt.remove(messageListener);
            if (ae2 == null) {
                b2.a(new Status(4002));
            } else {
                this.a(b2, ae2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void b(BaseImplementation.b<Status> b2, NodeApi.NodeListener nodeListener) throws RemoteException {
        HashMap<NodeApi.NodeListener, ax> hashMap = this.Gu;
        synchronized (hashMap) {
            ae ae2 = this.Gu.remove(nodeListener);
            if (ae2 == null) {
                b2.a(new Status(4002));
            } else {
                this.a(b2, ae2);
            }
        }
    }

    @Override
    protected /* synthetic */ IInterface d(IBinder iBinder) {
        return this.ar(iBinder);
    }

    private static class a
    extends com.google.android.gms.wearable.internal.a {
        private final BaseImplementation.b<DataApi.DataItemResult> sa;
        private final List<FutureTask<Boolean>> Gy;

        a(BaseImplementation.b<DataApi.DataItemResult> b2, List<FutureTask<Boolean>> list) {
            this.sa = b2;
            this.Gy = list;
        }

        @Override
        public void a(ao ao2) {
            this.sa.a(new f.a(new Status(ao2.statusCode), ao2.FZ));
            if (ao2.statusCode != 0) {
                for (FutureTask<Boolean> futureTask : this.Gy) {
                    futureTask.cancel(true);
                }
            }
        }
    }
}

