/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.ch;
import com.google.android.gms.internal.cr;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest Ft;
    private final DataMap Fs;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.Ft = putDataRequest;
        this.Fs = new DataMap();
        if (dataMap != null) {
            this.Fs.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.d(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.Ft.getUri();
    }

    public DataMap getDataMap() {
        return this.Fs;
    }

    public PutDataRequest asPutDataRequest() {
        ch.a a2 = ch.a(this.Fs);
        this.Ft.setData(cr.f(a2.GD));
        int n2 = a2.GE.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = Integer.toString(i2);
            Asset asset = a2.GE.get(i2);
            if (string == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string + " " + asset));
            }
            this.Ft.putAsset(string, asset);
        }
        return this.Ft;
    }
}

