/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.l;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final Object Av = new Object();
    private static Method Aw = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        l.a(context, (Object)"Context must not be null");
        GooglePlayServicesUtil.i(context);
        Context context2 = GooglePlayServicesUtil.getRemoteContext(context);
        if (context2 == null) {
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = Av;
        synchronized (object) {
            try {
                if (Aw == null) {
                    ProviderInstaller.y(context2);
                }
                Aw.invoke(null, context2);
            }
            catch (Exception exception) {
                Log.e((String)"ProviderInstaller", (String)("Failed to install provider: " + exception.getMessage()));
                throw new GooglePlayServicesNotAvailableException(8);
            }
        }
    }

    public static void installIfNeededAsync(final Context context, final ProviderInstallListener listener) {
        l.a(context, (Object)"Context must not be null");
        l.a(listener, (Object)"Listener must not be null");
        l.A("Must be called on the UI thread");
        AsyncTask<Void, Void, Integer> asyncTask = new AsyncTask<Void, Void, Integer>(){

            protected Integer a(Void ... voidArray) {
                try {
                    ProviderInstaller.installIfNeeded(context);
                }
                catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                    return googlePlayServicesRepairableException.getConnectionStatusCode();
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return googlePlayServicesNotAvailableException.errorCode;
                }
                return 0;
            }

            protected void a(Integer n2) {
                if (n2 == 0) {
                    listener.onProviderInstalled();
                } else {
                    Intent intent = GooglePlayServicesUtil.n(n2);
                    listener.onProviderInstallFailed(n2, intent);
                }
            }

            protected /* synthetic */ void onPostExecute(Object x0) {
                this.a((Integer)x0);
            }

            protected /* synthetic */ Object doInBackground(Object[] x0) {
                return this.a((Void[])x0);
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    private static void y(Context context) throws ClassNotFoundException, NoSuchMethodException {
        ClassLoader classLoader = context.getClassLoader();
        Class<?> clazz = classLoader.loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
        Class[] classArray = new Class[]{Context.class};
        Aw = clazz.getMethod("insertProvider", classArray);
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

