/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.g;
import com.google.android.gms.maps.model.h;

public final class LatLngBounds
implements SafeParcelable {
    public static final g CREATOR = new g();
    private final int nS;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        l.a(southwest, (Object)"null southwest");
        l.a(northeast, (Object)"null northeast");
        l.b(northeast.latitude >= southwest.latitude, "southern latitude exceeds northern latitude (%s > %s)", southwest.latitude, northeast.latitude);
        this.nS = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    int getVersionCode() {
        return this.nS;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.ej()) {
            h.a(this, out, flags);
        } else {
            g.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.a(latLng.latitude) && this.b(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.b(d5, d6) < LatLngBounds.c(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        return new LatLngBounds(new LatLng(d2, d5), new LatLng(d3, d4));
    }

    public LatLng getCenter() {
        double d2 = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d3 = this.southwest.longitude;
        double d4 = this.northeast.longitude;
        double d5 = d3 <= d4 ? (d4 + d3) / 2.0 : (d4 + 360.0 + d3) / 2.0;
        return new LatLng(d2, d5);
    }

    private static double b(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double c(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return k.hashCode(this.southwest, this.northeast);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o2;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return k.e(this).a("southwest", this.southwest).a("northeast", this.northeast).toString();
    }

    public static final class Builder {
        private double zV = Double.POSITIVE_INFINITY;
        private double zW = Double.NEGATIVE_INFINITY;
        private double zX = Double.NaN;
        private double zY = Double.NaN;

        public Builder include(LatLng point) {
            this.zV = Math.min(this.zV, point.latitude);
            this.zW = Math.max(this.zW, point.latitude);
            double d2 = point.longitude;
            if (Double.isNaN(this.zX)) {
                this.zX = d2;
                this.zY = d2;
            } else if (!this.b(d2)) {
                if (LatLngBounds.b(this.zX, d2) < LatLngBounds.c(this.zY, d2)) {
                    this.zX = d2;
                } else {
                    this.zY = d2;
                }
            }
            return this;
        }

        private boolean b(double d2) {
            if (this.zX <= this.zY) {
                return this.zX <= d2 && d2 <= this.zY;
            }
            return this.zX <= d2 || d2 <= this.zY;
        }

        public LatLngBounds build() {
            l.a(!Double.isNaN(this.zX), (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zV, this.zX), new LatLng(this.zW, this.zY));
        }
    }
}

