/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.c;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.t;
import com.google.android.gms.maps.internal.u;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class MapFragment
extends Fragment {
    private final b yM = new b(this);
    private GoogleMap yN;

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions options) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    protected IMapFragmentDelegate dW() {
        this.yM.dX();
        if (this.yM.bZ() == null) {
            return null;
        }
        return ((a)this.yM.bZ()).dW();
    }

    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.dW();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.yN == null || this.yN.dN().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.yN = new GoogleMap(iGoogleMapDelegate);
        }
        return this.yN;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.yM.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.yM.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.yM.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.yM.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.yM.onCreateView(inflater, container, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.yM.onResume();
    }

    public void onPause() {
        this.yM.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.yM.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.yM.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.yM.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.yM.onSaveInstanceState(outState);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class b
    extends com.google.android.gms.dynamic.a<a> {
        private final Fragment yO;
        protected d<a> yQ;
        private Activity pE;

        b(Fragment fragment) {
            this.yO = fragment;
        }

        @Override
        protected void a(d<a> d2) {
            this.yQ = d2;
            this.dX();
        }

        public void dX() {
            if (this.pE != null && this.yQ != null && this.bZ() == null) {
                try {
                    MapsInitializer.initialize((Context)this.pE);
                    IMapFragmentDelegate iMapFragmentDelegate = u.v((Context)this.pE).e(c.g(this.pE));
                    this.yQ.a(new a(this.yO, iMapFragmentDelegate));
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.pE = activity;
            this.dX();
        }
    }

    static class a
    implements LifecycleDelegate {
        private final Fragment yO;
        private final IMapFragmentDelegate yP;

        public a(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.yP = l.f(iMapFragmentDelegate);
            this.yO = l.f(fragment);
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.yP.onInflate(c.g(activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.yO.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    t.a(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.yP.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            com.google.android.gms.dynamic.b b2;
            try {
                b2 = this.yP.onCreateView(c.g(inflater), c.g(container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)c.a(b2);
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onResume() {
            try {
                this.yP.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.yP.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public void onDestroyView() {
            try {
                this.yP.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onDestroy() {
            try {
                this.yP.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onLowMemory() {
            try {
                this.yP.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.yP.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate dW() {
            return this.yP;
        }
    }
}

