/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.b;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final a CREATOR = new a();
    private final int nS;
    private Boolean yC;
    private Boolean yD;
    private int yE = -1;
    private CameraPosition yF;
    private Boolean yG;
    private Boolean yH;
    private Boolean yI;
    private Boolean yJ;
    private Boolean yK;
    private Boolean yL;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.nS = versionCode;
        this.yC = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.yD = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.yE = mapType;
        this.yF = camera;
        this.yG = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.yH = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.yI = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.yJ = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.yK = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.yL = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.ej()) {
            b.a(this, out, flags);
        } else {
            a.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.nS;
    }

    byte dO() {
        return com.google.android.gms.maps.internal.a.b(this.yC);
    }

    byte dP() {
        return com.google.android.gms.maps.internal.a.b(this.yD);
    }

    byte dQ() {
        return com.google.android.gms.maps.internal.a.b(this.yG);
    }

    byte dR() {
        return com.google.android.gms.maps.internal.a.b(this.yH);
    }

    byte dS() {
        return com.google.android.gms.maps.internal.a.b(this.yI);
    }

    byte dT() {
        return com.google.android.gms.maps.internal.a.b(this.yJ);
    }

    byte dU() {
        return com.google.android.gms.maps.internal.a.b(this.yK);
    }

    byte dV() {
        return com.google.android.gms.maps.internal.a.b(this.yL);
    }

    public GoogleMapOptions() {
        this.nS = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.yC = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.yD = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.yE = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.yF = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.yG = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.yH = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.yI = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.yJ = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.yK = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.yL = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.yC;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.yD;
    }

    public int getMapType() {
        return this.yE;
    }

    public CameraPosition getCamera() {
        return this.yF;
    }

    public Boolean getZoomControlsEnabled() {
        return this.yG;
    }

    public Boolean getCompassEnabled() {
        return this.yH;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.yI;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.yJ;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.yK;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.yL;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

