/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.b;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int nS;
    int mPriority;
    long un;
    long uo;
    boolean to;
    long uc;
    int up;
    float uq;
    long ur;
    public static final b CREATOR = new b();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.nS = 1;
        this.mPriority = 102;
        this.un = 3600000L;
        this.uo = 600000L;
        this.to = false;
        this.uc = Long.MAX_VALUE;
        this.up = Integer.MAX_VALUE;
        this.uq = 0.0f;
        this.ur = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.aJ(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.b(millis);
        this.un = millis;
        if (!this.to) {
            this.uo = (long)((double)this.un / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.un;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.b(millis);
        this.to = true;
        this.uo = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.uo;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.uc = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.uc < 0L) {
            this.uc = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.uc = millis;
        if (this.uc < 0L) {
            this.uc = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.uc;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.up = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.up;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.uq = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.uq;
    }

    private static void b(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void aJ(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.nS = versionCode;
        this.mPriority = priority;
        this.un = interval;
        this.uo = fastestInterval;
        this.to = explicitFastestInterval;
        this.uc = expireAt;
        this.up = numUpdates;
        this.uq = smallestDisplacement;
        this.ur = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        b.a(this, parcel, flags);
    }

    public static String aK(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.aK(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.un + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.uo + "ms");
        if (this.uc != Long.MAX_VALUE) {
            long l2 = this.uc - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.up != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.up);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return k.hashCode(this.mPriority, this.un, this.uo, this.to, this.uc, this.up, Float.valueOf(this.uq));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.un == locationRequest.un && this.uo == locationRequest.uo && this.to == locationRequest.to && this.uc == locationRequest.uc && this.up == locationRequest.up && this.uq == locationRequest.uq;
    }

    int getVersionCode() {
        return this.nS;
    }
}

