/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Subscription;
import com.google.android.gms.fitness.result.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListSubscriptionsResult
implements Result,
SafeParcelable {
    private final int nS;
    private final List<Subscription> tD;
    private final Status kW;
    public static final Parcelable.Creator<ListSubscriptionsResult> CREATOR = new e();

    ListSubscriptionsResult(int versionCode, List<Subscription> subscriptions, Status status) {
        this.nS = versionCode;
        this.tD = subscriptions;
        this.kW = status;
    }

    public ListSubscriptionsResult(List<Subscription> subscriptions, Status status) {
        this.nS = 3;
        this.tD = Collections.unmodifiableList(subscriptions);
        this.kW = l.a(status, (Object)"status");
    }

    public static ListSubscriptionsResult p(Status status) {
        return new ListSubscriptionsResult(Collections.emptyList(), status);
    }

    public List<Subscription> getSubscriptions() {
        return this.tD;
    }

    public List<Subscription> getSubscriptions(DataType dataType) {
        ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
        for (Subscription subscription : arrayList) {
            if (!subscription.getDataType().equals(dataType)) continue;
            arrayList.add(subscription);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Status getStatus() {
        return this.kW;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ListSubscriptionsResult && this.b((ListSubscriptionsResult)that);
    }

    private boolean b(ListSubscriptionsResult listSubscriptionsResult) {
        return this.kW.equals(listSubscriptionsResult.kW) && k.equal(this.tD, listSubscriptionsResult.tD);
    }

    public int hashCode() {
        return k.hashCode(this.kW, this.tD);
    }

    public String toString() {
        return k.e(this).a("status", this.kW).a("dataSets", this.tD).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        e.a(this, dest, flags);
    }
}

