/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.c;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataSourcesResult
implements Result,
SafeParcelable {
    private final int nS;
    private final List<DataSource> sO;
    private final Status kW;
    public static final Parcelable.Creator<DataSourcesResult> CREATOR = new c();

    DataSourcesResult(int versionCode, List<DataSource> dataSources, Status status) {
        this.nS = versionCode;
        this.sO = Collections.unmodifiableList(dataSources);
        this.kW = status;
    }

    public DataSourcesResult(List<DataSource> dataSources, Status status) {
        this.nS = 3;
        this.sO = Collections.unmodifiableList(dataSources);
        this.kW = status;
    }

    public static DataSourcesResult n(Status status) {
        return new DataSourcesResult(Collections.emptyList(), status);
    }

    public List<DataSource> getDataSources() {
        return this.sO;
    }

    public List<DataSource> getDataSources(DataType dataType) {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        for (DataSource dataSource : this.sO) {
            if (!dataSource.getDataType().equals(dataType)) continue;
            arrayList.add(dataSource);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Status getStatus() {
        return this.kW;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSourcesResult && this.b((DataSourcesResult)that);
    }

    private boolean b(DataSourcesResult dataSourcesResult) {
        return this.kW.equals(dataSourcesResult.kW) && k.equal(this.sO, dataSourcesResult.sO);
    }

    public int hashCode() {
        return k.hashCode(this.kW, this.sO);
    }

    public String toString() {
        return k.e(this).a("status", this.kW).a("dataSets", this.sO).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        c.a(this, dest, flags);
    }
}

