/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.b;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int nS;
    private final List<DataSet> rj;
    private final Status kW;
    private final List<Bucket> tA;
    private int tB;
    private final List<DataSource> ru;
    private final List<DataType> tC;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new b();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.nS = versionCode;
        this.kW = status;
        this.tB = batchCount;
        this.ru = uniqueDataSources;
        this.tC = uniqueDataTypes;
        this.rj = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet safeParcelable : dataSets) {
            this.rj.add(new DataSet(safeParcelable, uniqueDataSources, uniqueDataTypes));
        }
        this.tA = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.tA.add(new Bucket(rawBucket, uniqueDataSources, uniqueDataTypes));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.nS = 5;
        this.rj = dataSets;
        this.kW = status;
        this.tA = buckets;
        this.tB = 1;
        this.ru = new ArrayList<DataSource>();
        this.tC = new ArrayList<DataType>();
    }

    public static DataReadResult a(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource safeParcelable : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(safeParcelable));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.rj) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.rj) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.rj;
    }

    public List<Bucket> getBuckets() {
        return this.tA;
    }

    public int di() {
        return this.tB;
    }

    public void b(DataReadResult dataReadResult) {
        for (DataSet safeParcelable : dataReadResult.getDataSets()) {
            this.a(safeParcelable, this.rj);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.a(bucket, this.tA);
        }
    }

    private void a(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.a(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void a(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.b(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.a(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.tA.add(bucket);
    }

    @Override
    public Status getStatus() {
        return this.kW;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.c((DataReadResult)that);
    }

    private boolean c(DataReadResult dataReadResult) {
        return this.kW.equals(dataReadResult.kW) && k.equal(this.rj, dataReadResult.rj) && k.equal(this.tA, dataReadResult.tA);
    }

    public int hashCode() {
        return k.hashCode(this.kW, this.rj, this.tA);
    }

    public String toString() {
        return k.e(this).a("status", this.kW).a("dataSets", this.rj.size() > 5 ? this.rj.size() + " data sets" : this.rj).a("buckets", this.tA.size() > 5 ? this.tA.size() + " buckets" : this.tA).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    List<RawBucket> dj() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.tA.size());
        for (Bucket bucket : this.tA) {
            arrayList.add(new RawBucket(bucket, this.ru, this.tC));
        }
        return arrayList;
    }

    List<RawDataSet> dk() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.rj.size());
        for (DataSet dataSet : this.rj) {
            arrayList.add(new RawDataSet(dataSet, this.ru, this.tC));
        }
        return arrayList;
    }

    List<DataSource> ci() {
        return this.ru;
    }

    List<DataType> dl() {
        return this.tC;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }
}

