/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.r;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int nS;
    private final Session qW;
    private final List<DataSet> rj;
    private final List<DataPoint> tp;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new r();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints) {
        this.nS = versionCode;
        this.qW = session;
        this.rj = Collections.unmodifiableList(dataSets);
        this.tp = Collections.unmodifiableList(aggregateDataPoints);
    }

    private SessionInsertRequest(Builder builder) {
        this.nS = 1;
        this.qW = builder.qW;
        this.rj = Collections.unmodifiableList(builder.rj);
        this.tp = Collections.unmodifiableList(builder.tp);
    }

    public Session getSession() {
        return this.qW;
    }

    public List<DataSet> getDataSets() {
        return this.rj;
    }

    public List<DataPoint> cU() {
        return this.tp;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof SessionInsertRequest && this.a((SessionInsertRequest)o2);
    }

    private boolean a(SessionInsertRequest sessionInsertRequest) {
        return k.equal(this.qW, sessionInsertRequest.qW) && k.equal(this.rj, sessionInsertRequest.rj) && k.equal(this.tp, sessionInsertRequest.tp);
    }

    public int hashCode() {
        return k.hashCode(this.qW, this.rj, this.tp);
    }

    public String toString() {
        return k.e(this).a("session", this.qW).a("dataSets", this.rj).a("aggregateDataPoints", this.tp).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        r.a(this, dest, flags);
    }

    public static class Builder {
        private Session qW;
        private List<DataSet> rj = new ArrayList<DataSet>();
        private List<DataPoint> tp = new ArrayList<DataPoint>();
        private List<DataSource> tq = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.qW = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            l.b(dataSet != null, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            l.a(!this.tq.contains(dataSource), "Data set for this data source %s is already added.", dataSource);
            List<DataPoint> list = dataSet.getDataPoints();
            l.b(!list.isEmpty(), (Object)"No data points specified in the input data set.");
            this.tq.add(dataSource);
            this.rj.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            l.b(aggregateDataPoint != null, (Object)"Must specify a valid aggregate data point.");
            long l2 = aggregateDataPoint.getStartTimeNanos();
            long l3 = aggregateDataPoint.getEndTimeNanos();
            l.b(l2 > 0L && l3 > l2, "Aggregate data point should have valid start and end times: %s", aggregateDataPoint);
            DataSource dataSource = aggregateDataPoint.getDataSource();
            l.a(!this.tq.contains(dataSource), "Data set/Aggregate data point for this data source %s is already added.", dataSource);
            this.tq.add(dataSource);
            this.tp.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            l.a(this.qW != null, (Object)"Must specify a valid session.");
            l.a(this.qW.getEndTimeMillis() != 0L, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.cV();
            return new SessionInsertRequest(this);
        }

        private void c(DataPoint dataPoint) {
            long l2 = TimeUnit.MILLISECONDS.toNanos(this.qW.getStartTimeMillis());
            long l3 = TimeUnit.MILLISECONDS.toNanos(this.qW.getEndTimeMillis());
            long l4 = dataPoint.getTimestampNanos();
            if (l4 != 0L) {
                l.a(l4 >= l2 && l4 <= l3, "Data point %s has time stamp outside session interval [%d, %d]", dataPoint, l2, l3);
            }
            long l5 = dataPoint.getStartTimeNanos();
            long l6 = dataPoint.getEndTimeNanos();
            if (l5 != 0L && l6 != 0L) {
                l.a(l5 >= l2 && l6 <= l3, "Data point %s has start and end times outside session interval [%d, %d]", dataPoint, l2, l3);
            }
        }

        private void cV() {
            for (DataSet safeParcelable : this.rj) {
                for (DataPoint dataPoint : safeParcelable.getDataPoints()) {
                    this.c(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.tp) {
                this.c(dataPoint);
            }
        }
    }
}

