/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource qT;
    private final DataType rs;
    private final long rW;
    private final long ti;
    private final long th;
    private final int rX;
    private final LocationRequest tm;
    private final long tn;

    private SensorRequest(Builder builder) {
        this.qT = builder.qT;
        this.rs = builder.rs;
        this.rW = builder.rW;
        this.ti = builder.ti;
        this.th = builder.th;
        this.rX = builder.rX;
        this.tm = null;
        this.tn = builder.tn;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.tm = locationRequest;
        this.rW = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.ti = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.th = this.rW;
        this.rs = dataSource.getDataType();
        this.rX = SensorRequest.a(locationRequest);
        this.qT = dataSource;
        long l2 = locationRequest.getExpirationTime();
        this.tn = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l2 - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int a(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.qT;
    }

    public DataType getDataType() {
        return this.rs;
    }

    public long getSamplingRateMicros() {
        return this.rW;
    }

    public long cO() {
        return this.ti;
    }

    public long cP() {
        return this.th;
    }

    public int cs() {
        return this.rX;
    }

    public long cT() {
        return this.tn;
    }

    public String toString() {
        return k.e(this).a("dataSource", this.qT).a("dataType", this.rs).a("samplingRateMicros", this.rW).a("deliveryLatencyMicros", this.th).a("timeOutMicros", this.tn).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.a((SensorRequest)that);
    }

    private boolean a(SensorRequest sensorRequest) {
        return k.equal(this.qT, sensorRequest.qT) && k.equal(this.rs, sensorRequest.rs) && this.rW == sensorRequest.rW && this.ti == sensorRequest.ti && this.th == sensorRequest.th && this.rX == sensorRequest.rX && k.equal(this.tm, sensorRequest.tm) && this.tn == sensorRequest.tn;
    }

    public int hashCode() {
        return k.hashCode(this.qT, this.rs, this.rW, this.ti, this.th, this.rX, this.tm, this.tn);
    }

    public static int ao(int n2) {
        switch (n2) {
            case 1: 
            case 3: {
                return n2;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource qT;
        private DataType rs;
        private long rW = -1L;
        private long ti = 0L;
        private long th = 0L;
        private boolean to = false;
        private int rX = 2;
        private long tn = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.qT = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.rs = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            l.b(interval >= 0L, (Object)"Cannot use a negative sampling interval");
            this.rW = unit.toMicros(interval);
            if (!this.to) {
                this.ti = this.rW / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            l.b(fastestInterval >= 0, (Object)"Cannot use a negative interval");
            this.to = true;
            this.ti = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            l.b(interval >= 0, (Object)"Cannot use a negative delivery interval");
            this.th = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.rX = SensorRequest.ao(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            l.b(timeout > 0L, "Invalid time out value specified: %d", timeout);
            l.b(timeUnit != null, (Object)"Invalid time unit specified");
            this.tn = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            l.a(this.qT != null || this.rs != null, (Object)"Must call setDataSource() or setDataType()");
            l.a(this.rs == null || this.qT == null || this.rs.equals(this.qT.getDataType()), (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

