/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int nS;
    private final long pe;
    private final long qU;
    private final List<DataSource> sO;
    private final List<DataType> rh;
    private final List<Session> sP;
    private final boolean sQ;
    private final boolean sR;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new d();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions) {
        this.nS = versionCode;
        this.pe = startTimeMillis;
        this.qU = endTimeMillis;
        this.sO = Collections.unmodifiableList(dataSources);
        this.rh = Collections.unmodifiableList(dataTypes);
        this.sP = sessions;
        this.sQ = deleteAllData;
        this.sR = deleteAllSessions;
    }

    private DataDeleteRequest(Builder builder) {
        this.nS = 1;
        this.pe = builder.pe;
        this.qU = builder.qU;
        this.sO = Collections.unmodifiableList(builder.sO);
        this.rh = Collections.unmodifiableList(builder.rh);
        this.sP = Collections.unmodifiableList(builder.sP);
        this.sQ = builder.sQ;
        this.sR = builder.sR;
    }

    public long getStartTimeMillis() {
        return this.pe;
    }

    public long getEndTimeMillis() {
        return this.qU;
    }

    public List<DataSource> getDataSources() {
        return this.sO;
    }

    public List<DataType> getDataTypes() {
        return this.rh;
    }

    public List<Session> getSessions() {
        return this.sP;
    }

    public boolean cz() {
        return this.sQ;
    }

    public boolean cA() {
        return this.sR;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataDeleteRequest && this.a((DataDeleteRequest)o2);
    }

    private boolean a(DataDeleteRequest dataDeleteRequest) {
        return this.pe == dataDeleteRequest.pe && this.qU == dataDeleteRequest.qU && k.equal(this.sO, dataDeleteRequest.sO) && k.equal(this.rh, dataDeleteRequest.rh) && k.equal(this.sP, dataDeleteRequest.sP) && this.sQ == dataDeleteRequest.sQ && this.sR == dataDeleteRequest.sR;
    }

    public int hashCode() {
        return k.hashCode(this.pe, this.qU);
    }

    public String toString() {
        return k.e(this).a("startTimeMillis", this.pe).a("endTimeMillis", this.qU).a("dataSources", this.sO).a("dateTypes", this.rh).a("sessions", this.sP).a("deleteAllData", this.sQ).a("deleteAllSessions", this.sR).toString();
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }

    public static class Builder {
        private long pe;
        private long qU;
        private List<DataSource> sO = new ArrayList<DataSource>();
        private List<DataType> rh = new ArrayList<DataType>();
        private List<Session> sP = new ArrayList<Session>();
        private boolean sQ = false;
        private boolean sR = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            l.b(startTime > 0L, "Invalid start time :%d", startTime);
            l.b(endTime > startTime, "Invalid end time :%d", endTime);
            this.pe = timeUnit.toMillis(startTime);
            this.qU = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            l.b(this.rh.isEmpty() && this.sO.isEmpty(), "Specific data source/type already specified for deletion. DataSources: %s DataTypes: %s", this.sO, this.rh);
            this.sQ = true;
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            l.b(!this.sQ, (Object)"All data is already marked for deletion");
            l.b(dataSource != null, (Object)"Must specify a valid data source");
            if (!this.sO.contains(dataSource)) {
                this.sO.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            l.b(!this.sR, (Object)"All sessions already marked for deletion");
            l.b(session != null, (Object)"Must specify a valid session");
            l.b(session.getEndTimeMillis() > 0L, (Object)"Must specify a session that has already ended");
            this.sP.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            l.b(this.sP.isEmpty(), "Specific sessions already added for deletion: %s", this.sP);
            this.sR = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            l.b(!this.sQ, (Object)"All data is already marked for deletion");
            l.b(dataType != null, (Object)"Must specify a valid data type");
            if (!this.rh.contains(dataType)) {
                this.rh.add(dataType);
            }
            return this;
        }

        public DataDeleteRequest build() {
            l.a(this.pe > 0L && this.qU > this.pe, (Object)"Must specify a valid time interval");
            boolean bl2 = this.sQ || !this.sO.isEmpty() || !this.rh.isEmpty();
            boolean bl3 = this.sR || !this.sP.isEmpty();
            l.a(bl2 || bl3, (Object)"No data or session marked for deletion");
            this.cB();
            return new DataDeleteRequest(this);
        }

        private void cB() {
            if (this.sP.isEmpty()) {
                return;
            }
            for (Session session : this.sP) {
                l.a(session.getStartTimeMillis() >= this.pe && session.getEndTimeMillis() <= this.qU, "Session %s is outside the time interval [%d, %d]", session, this.pe, this.qU);
            }
        }
    }
}

