/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.m;
import java.util.ArrayList;
import java.util.List;

public final class RawBucket
implements SafeParcelable {
    final int nS;
    final long pe;
    final long qU;
    final Session qW;
    final int ri;
    final List<RawDataSet> rj;
    final int rk;
    final boolean rl;
    public static final Parcelable.Creator<RawBucket> CREATOR = new m();

    RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.nS = versionCode;
        this.pe = startTimeMillis;
        this.qU = endTimeMillis;
        this.qW = session;
        this.ri = activity;
        this.rj = dataSets;
        this.rk = bucketType;
        this.rl = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.nS = 2;
        this.pe = bucket.getStartTimeMillis();
        this.qU = bucket.getEndTimeMillis();
        this.qW = bucket.getSession();
        this.ri = bucket.getActivity();
        this.rk = bucket.getBucketType();
        this.rl = bucket.cd();
        List<DataSet> list = bucket.getDataSets();
        this.rj = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.rj.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof RawBucket && this.a((RawBucket)o2);
    }

    private boolean a(RawBucket rawBucket) {
        return this.pe == rawBucket.pe && this.qU == rawBucket.qU && this.ri == rawBucket.ri && k.equal(this.rj, rawBucket.rj) && this.rk == rawBucket.rk && this.rl == rawBucket.rl;
    }

    public int hashCode() {
        return k.hashCode(this.pe, this.qU, this.rk);
    }

    public String toString() {
        return k.e(this).a("startTime", this.pe).a("endTime", this.qU).a("activity", this.ri).a("dataSets", this.rj).a("bucketType", this.rk).a("serverHasMoreData", this.rl).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        m.a(this, parcel, flags);
    }
}

