/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.g;
import com.google.android.gms.internal.ai;

public class DataSource
implements SafeParcelable {
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int nS;
    private final DataType rs;
    private final String mName;
    private final int rv;
    private final Device rw;
    private final a rx;
    private final String ry;
    private final boolean rz;
    private final String rA;
    public static final Parcelable.Creator<DataSource> CREATOR = new g();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, a application, String streamName, boolean isObfuscated) {
        this.nS = versionCode;
        this.rs = dataType;
        this.rv = type;
        this.mName = name;
        this.rw = device;
        this.rx = application;
        this.ry = streamName;
        this.rz = isObfuscated;
        this.rA = this.ck();
    }

    private DataSource(Builder builder) {
        this.nS = 3;
        this.rs = builder.rs;
        this.rv = builder.rv;
        this.mName = builder.mName;
        this.rw = builder.rw;
        this.rx = builder.rx;
        this.ry = builder.ry;
        this.rz = builder.rz;
        this.rA = this.ck();
    }

    public DataType getDataType() {
        return this.rs;
    }

    public int getType() {
        return this.rv;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.rx == null ? null : this.rx.getPackageName();
    }

    public a cj() {
        return this.rx;
    }

    public Device getDevice() {
        return this.rw;
    }

    public String getStreamName() {
        return this.ry;
    }

    public String getStreamIdentifier() {
        return this.rA;
    }

    private String ck() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.rs.getName());
        if (this.rx != null) {
            stringBuilder.append(":").append(this.rx.getPackageName());
        }
        if (this.rw != null) {
            stringBuilder.append(":").append(this.rw.getStreamIdentifier());
        }
        if (this.ry != null) {
            stringBuilder.append(":").append(this.ry);
        }
        return stringBuilder.toString();
    }

    public boolean cl() {
        return this.rz;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.a((DataSource)that);
    }

    private boolean a(DataSource dataSource) {
        return this.rs.equals(dataSource.rs) && this.rv == dataSource.rv && k.equal(this.mName, dataSource.mName) && k.equal(this.rw, dataSource.rw) && k.equal(this.ry, dataSource.ry) && k.equal(this.rx, dataSource.rx);
    }

    public int hashCode() {
        return this.rA.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.rx != null) {
            stringBuilder.append(":").append(this.rx);
        }
        if (this.rw != null) {
            stringBuilder.append(":").append(this.rw);
        }
        if (this.ry != null) {
            stringBuilder.append(":").append(this.ry);
        }
        stringBuilder.append(":").append(this.rs);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.rv == 0 ? "r" : "d") + ":" + this.rs.cn() + (this.rx == null ? "" : (this.rx.equals(a.rb) ? ":gms" : ":" + this.rx.getPackageName())) + (this.rw != null ? ":" + this.rw.getModel() : "") + (this.ry != null ? ":" + this.ry : "");
    }

    private String getTypeString() {
        switch (this.rv) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    public DataSource cm() {
        Device device = this.rw == null ? null : this.rw.co();
        a a2 = this.rx == null ? null : this.rx.cc();
        return new DataSource(3, this.rs, this.mName, this.rv, device, a2, ai.H(this.ry), this.rz);
    }

    int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        DataSource dataSource = ai.c(this);
        g.a(dataSource, parcel, flags);
    }

    public static final class Builder {
        private DataType rs;
        private int rv = -1;
        private String mName;
        private Device rw;
        private a rx;
        private String ry = "";
        private boolean rz = false;

        public Builder setDataType(DataType dataType) {
            this.rs = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.rv = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.rw = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.rx = new a(packageName, null, null);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            l.b(streamName != null, (Object)"Must specify a valid stream name");
            this.ry = streamName;
            return this;
        }

        public Builder setObfuscated(boolean isObfuscated) {
            this.rz = isObfuscated;
            return this;
        }

        public DataSource build() {
            l.a(this.rs != null, (Object)"Must set data type");
            l.a(this.rv >= 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

