/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.e;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int nS;
    private final DataSource qT;
    private long rm;
    private long rn;
    private final Value[] ro;
    private DataSource rp;
    private long rq;
    private long rr;
    public static final Parcelable.Creator<DataPoint> CREATOR = new e();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.nS = versionCode;
        this.qT = dataSource;
        this.rp = originalDataSource;
        this.rm = timestampNanos;
        this.rn = startTimeNanos;
        this.ro = values;
        this.rq = rawTimestamp;
        this.rr = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(4, DataPoint.a(dataSources, rawDataPoint.rP), rawDataPoint.rm, rawDataPoint.rn, rawDataPoint.ro, DataPoint.a(dataSources, rawDataPoint.rQ), rawDataPoint.rq, rawDataPoint.rr);
    }

    private static DataSource a(List<DataSource> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? list.get(n2) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.nS = 4;
        this.qT = l.a(dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.ro = new Value[list.size()];
        int n2 = 0;
        for (Field field : list) {
            this.ro[n2] = new Value(field.getFormat());
            ++n2;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, "com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestampNanos(long timestampNanos) {
        this.rm = timestampNanos;
        return this;
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit unit) {
        return this.setTimestampNanos(unit.toNanos(timestamp));
    }

    public DataPoint setTimeIntervalNanos(long startTimeNanos, long endTimeNanos) {
        this.rn = startTimeNanos;
        this.rm = endTimeNanos;
        return this;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit unit) {
        return this.setTimeIntervalNanos(unit.toNanos(startTime), unit.toNanos(endTime));
    }

    public Value getValue(Field field) {
        int n2 = this.getDataType().indexOf(field);
        return this.ro[n2];
    }

    public Value[] ce() {
        return this.ro;
    }

    public DataPoint setFloatValues(float ... values) {
        this.P(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.ro[i2].setFloat(values[i2]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.P(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.ro[i2].setInt(values[i2]);
        }
        return this;
    }

    private void P(int n2) {
        List<Field> list = this.getDataType().getFields();
        int n3 = list.size();
        l.b(n2 == n3, "Attempting to insert %s values, but needed %s: %s", n2, n3, list);
    }

    public DataType getDataType() {
        return this.qT.getDataType();
    }

    public DataSource getDataSource() {
        return this.qT;
    }

    public DataSource getOriginalDataSource() {
        return this.rp;
    }

    public long getTimestampNanos() {
        return this.rm;
    }

    public long cf() {
        return this.rq;
    }

    public long cg() {
        return this.rr;
    }

    public long getStartTimeNanos() {
        return this.rn;
    }

    public long getEndTimeNanos() {
        return this.rm;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof DataPoint && this.a((DataPoint)o2);
    }

    private boolean a(DataPoint dataPoint) {
        return k.equal(this.qT, dataPoint.qT) && this.rm == dataPoint.rm && this.rn == dataPoint.rn && Arrays.equals(this.ro, dataPoint.ro) && k.equal(this.rp, dataPoint.rp);
    }

    public int hashCode() {
        return k.hashCode(this.qT, this.rm, this.rn);
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.ro), this.rn, this.rm, this.rq, this.rr, this.qT, this.rp);
    }

    public int getVersionCode() {
        return this.nS;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        e.a(this, parcel, flags);
    }
}

