/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.Context;
import android.content.Intent;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.FitnessIntents;
import com.google.android.gms.fitness.data.DataSource;

public class ViewDataIntentBuilder {
    private final Context mContext;
    private DataSource qT;
    private long pe;
    private long qU;
    private String qV;

    public ViewDataIntentBuilder(Context context) {
        this.mContext = context;
    }

    public ViewDataIntentBuilder setTimeInterval(long startTimeMillis, long endTimeMillis) {
        this.pe = startTimeMillis;
        this.qU = endTimeMillis;
        return this;
    }

    public ViewDataIntentBuilder setDataSource(DataSource dataSource) {
        this.qT = dataSource;
        return this;
    }

    public ViewDataIntentBuilder setPreferredApplication(String packageName) {
        this.qV = packageName;
        return this;
    }

    public Intent build() {
        l.a(this.qT != null, (Object)"Data source must be set");
        l.a(this.pe > 0L, (Object)"Start time must be set");
        l.a(this.qU > this.pe, (Object)"End time must be set and after start time");
        Intent intent = new Intent("vnd.google.fitness.VIEW");
        intent.setType(FitnessIntents.getDataTypeMimeType(this.qT.getDataType()));
        intent.putExtra("vnd.google.fitness.start_time", this.pe);
        intent.putExtra("vnd.google.fitness.end_time", this.qU);
        c.a(this.qT, intent, "vnd.google.fitness.data_source");
        return this.b(intent);
    }

    private Intent b(Intent intent) {
        if (this.qV == null) {
            return intent;
        }
        Intent intent2 = new Intent(intent).setPackage(this.qV);
        boolean bl2 = this.mContext.getPackageManager().resolveActivity(intent2, 0) != null;
        return bl2 ? intent2 : intent;
    }
}

