/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.d;
import com.google.android.gms.common.internal.h;
import com.google.android.gms.common.internal.i;
import com.google.android.gms.common.internal.l;
import java.util.ArrayList;

public abstract class c<T extends IInterface>
implements Api.a,
d.b {
    private final Context mContext;
    private final Looper ne;
    final Handler mHandler;
    private T pH;
    private final ArrayList<b<?>> pI = new ArrayList();
    private e pJ;
    private volatile int pK = 1;
    private final String[] kV;
    boolean pL = false;
    private final com.google.android.gms.common.internal.d nr;
    public static final String[] pM = new String[]{"service_esmobile", "service_googleme"};

    protected c(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = l.f(context);
        this.ne = l.a(looper, (Object)"Looper must not be null");
        this.nr = new com.google.android.gms.common.internal.d(context, looper, this);
        this.mHandler = new a(looper);
        this.b(stringArray);
        this.kV = stringArray;
        this.registerConnectionCallbacks(l.f(connectionCallbacks));
        this.registerConnectionFailedListener(l.f(onConnectionFailedListener));
    }

    @Deprecated
    protected c(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new f(onConnectionFailedListener), stringArray);
    }

    protected void b(String ... stringArray) {
    }

    protected abstract String getStartServiceAction();

    protected abstract String getServiceDescriptor();

    protected abstract T d(IBinder var1);

    private void C(int n2) {
        int n3 = this.pK;
        this.pK = n2;
        if (n3 != n2) {
            if (n2 == 3) {
                this.onConnected();
            } else if (n3 == 3 && n2 == 1) {
                this.onDisconnected();
            }
        }
    }

    protected void onConnected() {
    }

    protected void onDisconnected() {
    }

    @Override
    public void connect() {
        this.pL = true;
        this.C(2);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.C(1);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.pJ != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.pH = null;
            com.google.android.gms.common.internal.e.n(this.mContext).b(this.getStartServiceAction(), this.pJ);
        }
        this.pJ = new e();
        boolean bl2 = com.google.android.gms.common.internal.e.n(this.mContext).a(this.getStartServiceAction(), this.pJ);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.getStartServiceAction()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.pK == 3;
    }

    public boolean isConnecting() {
        return this.pK == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.pL = false;
        ArrayList<b<?>> arrayList = this.pI;
        synchronized (arrayList) {
            int n2 = this.pI.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pI.get(i2).bO();
            }
            this.pI.clear();
        }
        this.C(1);
        this.pH = null;
        if (this.pJ != null) {
            com.google.android.gms.common.internal.e.n(this.mContext).b(this.getStartServiceAction(), this.pJ);
            this.pJ = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.ne;
    }

    public final String[] bK() {
        return this.kV;
    }

    protected final void e(IBinder iBinder) {
        try {
            i i2 = i.a.g(iBinder);
            this.a(i2, new d(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(i var1, d var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new g(n2, iBinder, bundle)));
    }

    protected final void w() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle bs() {
        return null;
    }

    public final T bL() {
        this.w();
        return this.pH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.pI;
        synchronized (arrayList) {
            this.pI.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean br() {
        return this.pL;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.nr.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.nr.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.nr.registerConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.nr.isConnectionCallbacksRegistered(new c(listener));
    }

    @Deprecated
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.nr.unregisterConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.nr.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.nr.isConnectionFailedListenerRegistered(listener);
    }

    @Deprecated
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.nr.unregisterConnectionFailedListener(listener);
    }

    public static final class d
    extends h.a {
        private c pQ;

        public d(c c2) {
            this.pQ = c2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            l.a("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.pQ);
            this.pQ.a(n2, iBinder, bundle);
            this.pQ = null;
        }
    }

    protected final class g
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle pS;
        public final IBinder pT;

        public g(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.pT = iBinder;
            this.pS = bundle;
        }

        protected void a(Boolean bl2) {
            if (bl2 == null) {
                c.this.C(1);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.pT.getInterfaceDescriptor();
                        if (c.this.getServiceDescriptor().equals(string2)) {
                            c.this.pH = c.this.d(this.pT);
                            if (c.this.pH != null) {
                                c.this.C(3);
                                c.this.nr.y();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    com.google.android.gms.common.internal.e.n(c.this.mContext).b(c.this.getStartServiceAction(), c.this.pJ);
                    c.this.pJ = null;
                    c.this.C(1);
                    c.this.pH = null;
                    c.this.nr.b(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    c.this.C(1);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.pS != null) {
                        pendingIntent = (PendingIntent)this.pS.getParcelable("pendingIntent");
                    }
                    if (c.this.pJ != null) {
                        com.google.android.gms.common.internal.e.n(c.this.mContext).b(c.this.getStartServiceAction(), c.this.pJ);
                        c.this.pJ = null;
                    }
                    c.this.C(1);
                    c.this.pH = null;
                    c.this.nr.b(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void bM() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.a((Boolean)object);
        }
    }

    public static final class f
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener pR;

        public f(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.pR = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.pR.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof f) {
                return this.pR.equals(((f)other).pR);
            }
            return this.pR.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks pP;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.pP = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.pP.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.pP.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.pP.equals(((c)other).pP);
            }
            return this.pP.equals(other);
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean pO;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.pO = false;
        }

        protected abstract void d(TListener var1);

        protected abstract void bM();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bN() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.pO) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.d(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.bM();
                    throw runtimeException;
                }
            } else {
                this.bM();
            }
            b2 = this;
            synchronized (b2) {
                this.pO = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.bO();
            ArrayList arrayList = c.this.pI;
            synchronized (arrayList) {
                c.this.pI.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bO() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !c.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.bM();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                c.this.nr.b(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                c.this.C(1);
                c.this.pH = null;
                c.this.nr.D((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !c.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.bM();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.bN();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            c.this.e(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            c.this.mHandler.sendMessage(c.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

