/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.b;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new b();
    private final int nS;
    private final Uri pa;
    private final int pb;
    private final int pc;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.nS = versionCode;
        this.pa = url;
        this.pb = width;
        this.pc = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    int getVersionCode() {
        return this.nS;
    }

    public Uri getUrl() {
        return this.pa;
    }

    public int getWidth() {
        return this.pb;
    }

    public int getHeight() {
        return this.pc;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.pb, this.pc, this.pa.toString());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return k.equal(this.pa, webImage.pa) && this.pb == webImage.pb && this.pc == webImage.pc;
    }

    public int hashCode() {
        return k.hashCode(this.pa, this.pb, this.pc);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }
}

