/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.d;
import com.google.android.gms.common.internal.l;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class a
implements GoogleApiClient {
    private final Lock np = new ReentrantLock();
    private final Condition nq = this.np.newCondition();
    private final d nr;
    private final int ns;
    private final Looper ne;
    final Queue<c<?>> nt = new LinkedList();
    private ConnectionResult nu;
    private int nv;
    private volatile int nw = 4;
    private volatile int nx;
    private boolean ny = false;
    private int nz;
    private long nA = 5000L;
    final Handler nB;
    private final Bundle nC = new Bundle();
    private final Map<Api.c<?>, Api.a> nD = new HashMap();
    private final List<String> nE;
    private boolean nF;
    private final Set<com.google.android.gms.common.api.b<?>> nG = Collections.newSetFromMap(new WeakHashMap());
    final Set<c<?>> nH = Collections.newSetFromMap(new ConcurrentHashMap());
    private final a mW = new a(){

        @Override
        public void b(c<?> c2) {
            a.this.nH.remove(c2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks nI = new GoogleApiClient.ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(Bundle connectionHint) {
            a.this.np.lock();
            try {
                if (a.this.nw == 1) {
                    if (connectionHint != null) {
                        a.this.nC.putAll(connectionHint);
                    }
                    a.this.bn();
                }
            }
            finally {
                a.this.np.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConnectionSuspended(int cause) {
            a.this.np.lock();
            try {
                a.this.o(cause);
                switch (cause) {
                    case 2: {
                        a.this.connect();
                        return;
                    }
                    case 1: {
                        if (a.this.bp()) {
                            return;
                        }
                        a.this.nx = 2;
                        a.this.nB.sendMessageDelayed(a.this.nB.obtainMessage(1), a.this.nA);
                        return;
                    }
                }
                return;
            }
            finally {
                a.this.np.unlock();
            }
        }
    };
    private final d.b nJ = new d.b(){

        @Override
        public boolean br() {
            return a.this.nF;
        }

        @Override
        public boolean isConnected() {
            return a.this.isConnected();
        }

        @Override
        public Bundle bs() {
            return null;
        }
    };

    public a(Context context, Looper looper, ClientSettings clientSettings, Map<Api<?>, Api.ApiOptions> map, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2, int n2) {
        this.nr = new d(context, looper, this.nJ);
        this.ne = looper;
        this.nB = new b(looper);
        this.ns = n2;
        for (GoogleApiClient.ConnectionCallbacks object : set) {
            this.nr.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.nr.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : map.keySet()) {
            final Api.b b2 = api.bd();
            Api.ApiOptions apiOptions = map.get(api);
            this.nD.put(api.bf(), (Api.a)a.a(b2, apiOptions, context, looper, clientSettings, this.nI, new GoogleApiClient.OnConnectionFailedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    a.this.np.lock();
                    try {
                        if (a.this.nu == null || b2.getPriority() < a.this.nv) {
                            a.this.nu = result;
                            a.this.nv = b2.getPriority();
                        }
                        a.this.bn();
                    }
                    finally {
                        a.this.np.unlock();
                    }
                }
            }));
        }
        this.nE = Collections.unmodifiableList(clientSettings.getScopes());
    }

    private static <C extends Api.a, O> C a(Api.b<C, O> b2, Object object, Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return b2.a(context, looper, clientSettings, object, connectionCallbacks, onConnectionFailedListener);
    }

    private void bn() {
        --this.nz;
        if (this.nz == 0) {
            if (this.nu != null) {
                this.ny = false;
                this.o(3);
                if (this.bp()) {
                    this.nB.sendMessageDelayed(this.nB.obtainMessage(1), this.nA);
                } else {
                    this.nr.b(this.nu);
                }
                this.nF = false;
            } else {
                this.nw = 2;
                this.bq();
                this.nq.signalAll();
                this.bo();
                if (this.ny) {
                    this.ny = false;
                    this.o(-1);
                } else {
                    Bundle bundle = this.nC.isEmpty() ? null : this.nC;
                    this.nr.a(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.a, R extends Result, T extends BaseImplementation.a<R, A>> T a(T t2) {
        this.np.lock();
        try {
            t2.a(new BaseImplementation.CallbackHandler(this.getLooper()));
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.nt.add(t2);
            }
            T t3 = t2;
            return t3;
        }
        finally {
            this.np.unlock();
        }
    }

    @Override
    public <A extends Api.a, T extends BaseImplementation.a<? extends Result, A>> T b(T t2) {
        l.a(this.isConnected() || this.bp(), (Object)"GoogleApiClient is not connected yet.");
        this.bo();
        try {
            this.a((c<A>)t2);
        }
        catch (DeadObjectException deadObjectException) {
            this.o(1);
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.a> void a(c<A> c2) throws DeadObjectException {
        this.np.lock();
        try {
            l.b(c2.bf() != null, (Object)"This task can not be executed or enqueued (it's probably a Batch or malformed)");
            this.nH.add(c2);
            c2.a(this.mW);
            if (this.bp()) {
                c2.b(new Status(8));
                return;
            }
            A a2 = this.a(c2.bf());
            c2.a(a2);
        }
        finally {
            this.np.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bo() {
        this.np.lock();
        try {
            l.a(this.isConnected() || this.bp(), (Object)"GoogleApiClient is not connected yet.");
            while (!this.nt.isEmpty()) {
                try {
                    this.a(this.nt.remove());
                }
                catch (DeadObjectException deadObjectException) {
                    Log.w((String)"GoogleApiClientImpl", (String)"Service died while flushing queue", (Throwable)deadObjectException);
                }
            }
        }
        finally {
            this.np.unlock();
        }
    }

    @Override
    public <C extends Api.a> C a(Api.c<C> c2) {
        Api.a a2 = this.nD.get(c2);
        l.a(a2, (Object)"Appropriate Api was not requested.");
        return (C)a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.np.lock();
        try {
            this.ny = false;
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.nF = true;
            this.nu = null;
            this.nw = 1;
            this.nC.clear();
            this.nz = this.nD.size();
            for (Api.a a2 : this.nD.values()) {
                a2.connect();
            }
        }
        finally {
            this.np.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        l.a(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.np.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.nq.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.np.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.mf;
                return connectionResult;
            }
            if (this.nu != null) {
                ConnectionResult connectionResult = this.nu;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.np.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        l.a(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.np.lock();
        try {
            this.connect();
            long l2 = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l2 = this.nq.awaitNanos(l2);
                    if (l2 > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.mf;
                return connectionResult;
            }
            if (this.nu != null) {
                ConnectionResult connectionResult = this.nu;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.np.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.bq();
        this.o(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o(int n2) {
        this.np.lock();
        try {
            if (this.nw != 3) {
                if (n2 == -1) {
                    if (this.isConnecting()) {
                        Iterator<Object> iterator = this.nt.iterator();
                        while (iterator.hasNext()) {
                            c object = (c)iterator.next();
                            if (object.bk() == 1) continue;
                            object.cancel();
                            iterator.remove();
                        }
                    } else {
                        this.nt.clear();
                    }
                    for (c c2 : this.nH) {
                        c2.cancel();
                    }
                    this.nH.clear();
                    for (com.google.android.gms.common.api.b b2 : this.nG) {
                        b2.clear();
                    }
                    this.nG.clear();
                    if (this.nu == null && !this.nt.isEmpty()) {
                        this.ny = true;
                        return;
                    }
                }
                boolean bl2 = this.isConnecting();
                boolean bl3 = this.isConnected();
                this.nw = 3;
                if (bl2) {
                    if (n2 == -1) {
                        this.nu = null;
                    }
                    this.nq.signalAll();
                }
                this.nF = false;
                for (Api.a a2 : this.nD.values()) {
                    if (!a2.isConnected()) continue;
                    a2.disconnect();
                }
                this.nF = true;
                this.nw = 4;
                if (bl3) {
                    if (n2 != -1) {
                        this.nr.D(n2);
                    }
                    this.nF = false;
                }
            }
        }
        finally {
            this.np.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public void stopAutoManage(FragmentActivity lifecycleActivity) {
        l.a(this.ns >= 0, (Object)"Called stopAutoManage but automatic lifecycle management is not enabled.");
        com.google.android.gms.common.api.c.a(lifecycleActivity).q(this.ns);
    }

    @Override
    public boolean isConnected() {
        return this.nw == 2;
    }

    @Override
    public boolean isConnecting() {
        return this.nw == 1;
    }

    private boolean bp() {
        return this.nx != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bq() {
        this.np.lock();
        try {
            this.nx = 0;
            this.nB.removeMessages(1);
        }
        finally {
            this.np.unlock();
        }
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.nr.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.nr.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.nr.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.nr.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.nr.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.nr.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Looper getLooper() {
        return this.ne;
    }

    class b
    extends Handler {
        b(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                a.this.np.lock();
                try {
                    if (a.this.isConnected() || a.this.isConnecting() || !a.this.bp()) {
                        return;
                    }
                    a.this.nx--;
                    a.this.connect();
                    return;
                }
                finally {
                    a.this.np.unlock();
                }
            }
            Log.wtf((String)"GoogleApiClientImpl", (String)"Don't know how to handle this message.");
        }
    }

    static interface c<A extends Api.a> {
        public void cancel();

        public Api.c<A> bf();

        public void a(A var1) throws DeadObjectException;

        public void b(Status var1);

        public void a(a var1);

        public int bk();
    }

    static interface a {
        public void b(c<?> var1);
    }
}

