/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

public final class Status
implements Result,
SafeParcelable {
    public static final Status nN = new Status(0);
    public static final Status nO = new Status(14);
    public static final Status nP = new Status(8);
    public static final Status nQ = new Status(15);
    public static final Status nR = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int nS;
    private final int mg;
    private final String nT;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.nS = versionCode;
        this.mg = statusCode;
        this.nT = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(1, statusCode, null, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.nT;
    }

    int getVersionCode() {
        return this.nS;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.mg <= 0;
    }

    public boolean isCanceled() {
        return this.mg == 16;
    }

    public boolean isInterrupted() {
        return this.mg == 14;
    }

    public int getStatusCode() {
        return this.mg;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return k.hashCode(this.nS, this.mg, this.nT, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.nS == status.nS && this.mg == status.mg && k.equal(this.nT, status.nT) && k.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String aZ() {
        if (this.nT != null) {
            return this.nT;
        }
        return CommonStatusCodes.getStatusCodeString(this.mg);
    }

    public String toString() {
        return k.e(this).a("statusCode", this.aZ()).a("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

