/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.internal.g;
import com.google.android.gms.common.internal.l;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BaseImplementation {
    static void a(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"GoogleApi", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public static final int CALLBACK_ON_COMPLETE = 1;
        public static final int CALLBACK_ON_TIMEOUT = 2;

        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void sendTimeoutResultCallback(AbstractPendingResult<R> pendingResult, long millis) {
            this.sendMessageDelayed(this.obtainMessage(2, pendingResult), millis);
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.bj();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                BaseImplementation.a(result);
                throw runtimeException;
            }
        }
    }

    public static abstract class AbstractPendingResult<R extends Result>
    implements b<R>,
    PendingResult<R> {
        private final Object mN = new Object();
        protected CallbackHandler<R> mHandler;
        private final CountDownLatch mO = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> mP = new ArrayList();
        private ResultCallback<R> mQ;
        private volatile R mR;
        private volatile boolean mS;
        private boolean mT;
        private boolean mU;
        private g mV;

        AbstractPendingResult() {
        }

        public AbstractPendingResult(Looper looper) {
            this.mHandler = new CallbackHandler(looper);
        }

        public AbstractPendingResult(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }

        protected abstract R a(Status var1);

        public final boolean isReady() {
            return this.mO.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R bg() {
            Object object = this.mN;
            synchronized (object) {
                l.a(!this.mS, (Object)"Result has already been consumed.");
                l.a(this.isReady(), (Object)"Result is not ready.");
                R r2 = this.mR;
                this.bh();
                return r2;
            }
        }

        @Override
        public final R await() {
            l.a(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
            l.a(!this.mS, (Object)"Result has already been consumed");
            try {
                this.mO.await();
            }
            catch (InterruptedException interruptedException) {
                this.bi();
            }
            l.a(this.isReady(), (Object)"Result is not ready.");
            return this.bg();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            l.a(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
            l.a(!this.mS, (Object)"Result has already been consumed.");
            try {
                boolean bl2 = this.mO.await(time, units);
                if (!bl2) {
                    this.bj();
                }
            }
            catch (InterruptedException interruptedException) {
                this.bi();
            }
            l.a(this.isReady(), (Object)"Result is not ready.");
            return this.bg();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            l.a(!this.mS, (Object)"Result has already been consumed.");
            Object object = this.mN;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.bg());
                } else {
                    this.mQ = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            l.a(!this.mS, (Object)"Result has already been consumed.");
            l.a(this.mHandler != null, (Object)"CallbackHandler has not been set before calling setResultCallback.");
            Object object = this.mN;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.mHandler.sendResultCallback(callback, this.bg());
                } else {
                    this.mQ = callback;
                    this.mHandler.sendTimeoutResultCallback(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            l.a(!this.mS, (Object)"Result has already been consumed.");
            Object object = this.mN;
            synchronized (object) {
                if (this.isReady()) {
                    a2.c(this.mR.getStatus());
                } else {
                    this.mP.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.mN;
            synchronized (object) {
                if (this.mT || this.mS) {
                    return;
                }
                if (this.mV != null) {
                    try {
                        this.mV.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                BaseImplementation.a(this.mR);
                this.mQ = null;
                this.mT = true;
                this.c(this.a(Status.nR));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.mN;
            synchronized (object) {
                return this.mT;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void b(R r2) {
            Object object = this.mN;
            synchronized (object) {
                if (this.mU || this.mT) {
                    BaseImplementation.a(r2);
                    return;
                }
                l.a(!this.isReady(), (Object)"Results have already been set");
                l.a(!this.mS, (Object)"Result has already been consumed");
                this.c(r2);
            }
        }

        protected void bh() {
            this.mS = true;
            this.mR = null;
            this.mQ = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bi() {
            Object object = this.mN;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.a(Status.nO));
                    this.mU = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bj() {
            Object object = this.mN;
            synchronized (object) {
                if (!this.isReady()) {
                    this.b(this.a(Status.nQ));
                    this.mU = true;
                }
            }
        }

        private void c(R r2) {
            this.mR = r2;
            this.mV = null;
            this.mO.countDown();
            Status status = this.mR.getStatus();
            if (this.mQ != null) {
                this.mHandler.removeTimeoutMessages();
                if (!this.mT) {
                    this.mHandler.sendResultCallback(this.mQ, this.bg());
                }
            }
            for (PendingResult.a a2 : this.mP) {
                a2.c(status);
            }
            this.mP.clear();
        }

        @Override
        protected void a(CallbackHandler<R> callbackHandler) {
            this.mHandler = callbackHandler;
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.b((Result)object);
        }
    }

    public static abstract class a<R extends Result, A extends Api.a>
    extends AbstractPendingResult<R>
    implements a.c<A> {
        private final Api.c<A> mL;
        private a.a mW;

        protected a(Api.c<A> c2) {
            this.mL = l.f(c2);
        }

        @Override
        public final Api.c<A> bf() {
            return this.mL;
        }

        @Override
        public final void a(A a2) throws DeadObjectException {
            if (this.mHandler == null) {
                this.a((A)((Object)new CallbackHandler(a2.getLooper())));
            }
            try {
                this.b(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void b(Status status) {
            l.b(!status.isSuccess(), (Object)"Failed result must not be success");
            this.b((A)this.a(status));
        }

        @Override
        public void a(a.a a2) {
            this.mW = a2;
        }

        @Override
        public int bk() {
            return 0;
        }

        @Override
        protected abstract void b(A var1) throws RemoteException;

        @Override
        protected void bh() {
            super.bh();
            if (this.mW != null) {
                this.mW.b(this);
                this.mW = null;
            }
        }

        @Override
        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.b(status);
        }
    }

    public static interface b<R> {
        public void a(R var1);
    }
}

