/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api;

import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.auth.api.GoogleAuthApiRequestCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleAuthApiRequest
implements SafeParcelable {
    public static final int HTTP_METHOD_GET = 0;
    public static final int HTTP_METHOD_POST = 1;
    public static final int HTTP_METHOD_PUT = 2;
    public static final int HTTP_METHOD_DELETE = 3;
    public static final int HTTP_METHOD_HEAD = 4;
    public static final int HTTP_METHOD_OPTIONS = 5;
    public static final int HTTP_METHOD_TRACE = 6;
    public static final int HTTP_METHOD_PATCH = 7;
    public static final GoogleAuthApiRequestCreator CREATOR = new GoogleAuthApiRequestCreator();
    public static final int VERSION_CODE = 1;
    public static final String DEFAULT_SCOPE_PREFIX = "oauth2:";
    final int versionCode;
    String name;
    String version;
    String kX;
    String hK;
    Bundle kY;
    String kZ;
    List<String> la;
    String lb;
    int lc;
    Bundle ld;
    byte[] le;
    long lf;

    public GoogleAuthApiRequest(String name, String version, String apiId) {
        this.versionCode = 1;
        this.name = name;
        this.y(version);
        this.kX = apiId;
        this.kY = new Bundle();
        this.la = new ArrayList<String>();
        this.lb = DEFAULT_SCOPE_PREFIX;
        this.ld = new Bundle();
        this.le = new byte[0];
    }

    public GoogleAuthApiRequest(String name, String version, String path, int httpMethod) {
        this.versionCode = 1;
        this.name = name;
        this.y(version);
        this.setPath(path);
        this.m(httpMethod);
        this.kY = new Bundle();
        this.la = new ArrayList<String>();
        this.lb = DEFAULT_SCOPE_PREFIX;
        this.ld = new Bundle();
        this.le = new byte[0];
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    private void y(String string2) {
        if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
            string2 = "v" + string2;
        }
        this.version = string2;
    }

    public String getApiId() {
        return this.kX;
    }

    public String getPath() {
        return this.hK;
    }

    private void setPath(String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        this.hK = path;
    }

    public String getAccountName() {
        return this.kZ;
    }

    public void setAccountName(String accountName) {
        this.kZ = accountName;
    }

    public String getScope() {
        if (this.la.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.la.size(); ++i2) {
            stringBuffer.append(this.la.get(i2));
            if (i2 == this.la.size() - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String getFullScope() {
        String string2 = this.getScope();
        if (string2 == null) {
            return null;
        }
        return this.lb + string2;
    }

    public void addScope(String scope) {
        this.la.add(scope);
    }

    public Bundle getParameters() {
        return this.kY;
    }

    public Map<String, List<String>> getParametersAsMap() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string2 : this.kY.keySet()) {
            hashMap.put(string2, this.kY.getStringArrayList(string2));
        }
        return hashMap;
    }

    public void addParameter(String key, String value) {
        if (!this.kY.containsKey(key)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(value);
            this.kY.putStringArrayList(key, arrayList);
        } else {
            this.kY.getStringArrayList(key).add(value);
        }
    }

    public int getHttpMethod() {
        return this.lc;
    }

    private void m(int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid HTTP method.");
        }
        this.lc = n2;
    }

    public void putHeader(String key, String value) {
        this.ld.putString(key, value);
    }

    public String getHeader(String key) {
        return this.ld.getString(key);
    }

    public Bundle getHeaders() {
        return this.ld;
    }

    public Map<String, String> getHeadersAsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : this.ld.keySet()) {
            hashMap.put(string2, this.ld.getString(string2));
        }
        return hashMap;
    }

    public byte[] getHttpBody() {
        return this.le;
    }

    public JSONObject getHttpBodyAsJson() throws JSONException {
        try {
            String string2 = new String(this.le, "UTF-8");
            return new JSONObject(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"GoogleAuthApiRequest", (String)"Unsupported encoding error.");
            return null;
        }
    }

    public void setHttpBody(String string2) {
        try {
            this.le = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"GoogleAuthApiRequest", (String)"Unsupported encoding error.");
        }
    }

    public long getTimeout() {
        return this.lf;
    }

    public void setTimeout(long timeout) {
        this.lf = timeout;
    }

    public String toString() {
        return "{ API: " + this.name + "/" + this.version + ", Scope: " + this.getFullScope() + ", Account: " + this.getAccountName() + " }";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        GoogleAuthApiRequestCreator.a(this, parcel, flags);
    }

    GoogleAuthApiRequest(int versionCode, String name, String version, String apiId, String path, Bundle parameters, String accountName, List<String> scopes, String scopePrefix, int httpMethod, Bundle headers, byte[] body, long timeout) {
        this.versionCode = versionCode;
        this.name = name;
        this.version = version;
        this.kX = apiId;
        this.hK = path;
        this.kY = parameters;
        this.kZ = accountName;
        this.la = scopes;
        this.lb = scopePrefix;
        this.lc = httpMethod;
        this.ld = headers;
        this.le = body;
        this.lf = timeout;
    }
}

