/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.a;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.internal.f;
import java.io.IOException;

public final class AdvertisingIdClient {
    final Context mContext;
    a gn;
    f go;
    boolean gp;

    public AdvertisingIdClient(Context context) {
        l.f(context);
        this.mContext = context;
        this.gp = false;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        l.B("Calling this from your main thread can lead to deadlock");
        if (this.gp) {
            this.finish();
        }
        this.gn = AdvertisingIdClient.a(this.mContext);
        this.go = AdvertisingIdClient.a(this.mContext, this.gn);
        this.gp = true;
    }

    public Info s() throws IOException {
        l.B("Calling this from your main thread can lead to deadlock");
        l.f(this.gn);
        l.f(this.go);
        if (!this.gp) {
            throw new IOException("AdvertisingIdService is not connected.");
        }
        try {
            return new Info(this.go.getId(), this.go.a(true));
        }
        catch (RemoteException remoteException) {
            Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
            throw new IOException("Remote exception");
        }
    }

    public void finish() {
        l.B("Calling this from your main thread can lead to deadlock");
        if (this.mContext == null || this.gn == null) {
            return;
        }
        try {
            if (this.gp) {
                this.mContext.unbindService((ServiceConnection)this.gn);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
        }
        this.gp = false;
        this.go = null;
        this.gn = null;
    }

    static a a(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        try {
            object = context.getPackageManager();
            object.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        try {
            GooglePlayServicesUtil.i(context);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new IOException(googlePlayServicesNotAvailableException);
        }
        object = new a();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)object, 1)) {
            return object;
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context);
        try {
            advertisingIdClient.start();
            Info info = advertisingIdClient.s();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static f a(Context context, a a2) throws IOException {
        try {
            return f.a.b(a2.aY());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
    }

    public static final class Info {
        private final String gq;
        private final boolean gr;

        public Info(String advertisingId, boolean limitAdTrackingEnabled) {
            this.gq = advertisingId;
            this.gr = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.gq;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.gr;
        }

        public String toString() {
            return "{" + this.gq + "}" + this.gr;
        }
    }
}

