/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzh;
import com.google.android.gms.internal.zzwb;
import com.google.android.gms.internal.zzwc;
import com.google.android.gms.internal.zzwj;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzaEt;
    private boolean mCreated = false;
    private final zzh zzaEu = zzh.zza((Fragment)this);
    private final zzc zzaEv = new zzc();
    private zza zzaEw = new zza(this);
    private final Fragment zzPt = this;
    private WalletFragmentOptions zzaEx;
    private WalletFragmentInitParams zzaEy;
    private MaskedWalletRequest zzaEz;
    private MaskedWallet zzaEA;
    private Boolean zzaEB;

    public static SupportWalletFragment newInstance(WalletFragmentOptions options) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        supportWalletFragment.zzPt.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzaEt != null) {
            this.zzaEt.initialize(initParams);
            this.zzaEy = null;
        } else if (this.zzaEy == null) {
            this.zzaEy = initParams;
            if (this.zzaEz != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzaEA != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzaEt != null) {
            this.zzaEt.updateMaskedWalletRequest(request);
            this.zzaEz = null;
        } else {
            this.zzaEz = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzaEt != null) {
            this.zzaEt.updateMaskedWallet(maskedWallet);
            this.zzaEA = null;
        } else {
            this.zzaEA = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzaEt != null) {
            this.zzaEt.setEnabled(enabled);
            this.zzaEB = null;
        } else {
            this.zzaEB = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzaEw.zza(listener);
    }

    public int getState() {
        return this.zzaEt != null ? this.zzaEt.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzaEx == null) {
            this.zzaEx = WalletFragmentOptions.zza((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzaEx);
        this.zzaEv.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzaEy != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzaEy = walletFragmentInitParams;
            }
            if (this.zzaEz == null) {
                this.zzaEz = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzaEA == null) {
                this.zzaEA = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzaEx = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzaEB = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzPt.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzPt.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzao((Context)this.zzPt.getActivity());
            this.zzaEx = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzaEv.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzaEv.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzaEv.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzaEv.onResume();
        FragmentManager fragmentManager = this.zzPt.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzPt.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzPt.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzaEv.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzaEv.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzaEv.onSaveInstanceState(outState);
        if (this.zzaEy != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzaEy);
            this.zzaEy = null;
        }
        if (this.zzaEz != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzaEz);
            this.zzaEz = null;
        }
        if (this.zzaEA != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzaEA);
            this.zzaEA = null;
        }
        if (this.zzaEx != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzaEx);
            this.zzaEx = null;
        }
        if (this.zzaEB != null) {
            outState.putBoolean("enabled", this.zzaEB.booleanValue());
            this.zzaEB = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzaEt != null) {
            this.zzaEt.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzwc.zza {
        private OnStateChangedListener zzaEC;
        private final SupportWalletFragment zzaED;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzaED = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzaEC != null) {
                this.zzaEC.onStateChanged(this.zzaED, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzaEC = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzwb zzaEE;

        private zzb(zzwb zzwb2) {
            this.zzaEE = zzwb2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzaEE.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzaEE.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzaEE.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzaEE.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzaEE.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzaEE.zza(zze.zzn((Object)activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaEE.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzaEE.onCreateView(zze.zzn((Object)inflater), zze.zzn((Object)container), savedInstanceState);
                return (View)zze.zzf((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzaEE.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzaEE.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaEE.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzaEE.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaEE.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzaEE.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzPt.getActivity();
            if (SupportWalletFragment.this.zzaEt == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzwb zzwb2 = zzwj.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.zzaEu, SupportWalletFragment.this.zzaEx, SupportWalletFragment.this.zzaEw);
                    SupportWalletFragment.this.zzaEt = new zzb(zzwb2);
                    SupportWalletFragment.this.zzaEx = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)SupportWalletFragment.this.zzaEt);
                if (SupportWalletFragment.this.zzaEy != null) {
                    SupportWalletFragment.this.zzaEt.initialize(SupportWalletFragment.this.zzaEy);
                    SupportWalletFragment.this.zzaEy = null;
                }
                if (SupportWalletFragment.this.zzaEz != null) {
                    SupportWalletFragment.this.zzaEt.updateMaskedWalletRequest(SupportWalletFragment.this.zzaEz);
                    SupportWalletFragment.this.zzaEz = null;
                }
                if (SupportWalletFragment.this.zzaEA != null) {
                    SupportWalletFragment.this.zzaEt.updateMaskedWallet(SupportWalletFragment.this.zzaEA);
                    SupportWalletFragment.this.zzaEA = null;
                }
                if (SupportWalletFragment.this.zzaEB != null) {
                    SupportWalletFragment.this.zzaEt.setEnabled(SupportWalletFragment.this.zzaEB);
                    SupportWalletFragment.this.zzaEB = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.zzPt.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.zzaEx != null && (walletFragmentStyle = SupportWalletFragment.this.zzaEx.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.zzPt.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzPt.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

