/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zztm;
import com.google.android.gms.internal.zztn;
import com.google.android.gms.internal.zzto;
import com.google.android.gms.internal.zztp;
import com.google.android.gms.internal.zztq;
import com.google.android.gms.plus.Account;
import com.google.android.gms.plus.Moments;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.internal.PlusCommonExtras;
import com.google.android.gms.plus.internal.zze;
import com.google.android.gms.plus.internal.zzh;
import com.google.android.gms.plus.zzb;
import java.util.HashSet;
import java.util.Set;

public final class Plus {
    public static final Api.zzc<zze> zzGR = new Api.zzc();
    static final Api.zzb<zze, PlusOptions> zzGS = new Api.zzb<zze, PlusOptions>(){

        public zze zza(Context context, Looper looper, zzf zzf2, PlusOptions plusOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (plusOptions == null) {
                plusOptions = new PlusOptions();
            }
            return new zze(context, looper, zzf2, new zzh(zzf2.zziM(), zzf2.zziQ(), plusOptions.zzaui.toArray(new String[0]), new String[0], context.getPackageName(), context.getPackageName(), null, new PlusCommonExtras()), connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 2;
        }
    };
    public static final Api<PlusOptions> API = new Api(zzGS, zzGR, new Scope[0]);
    public static final Scope SCOPE_PLUS_LOGIN = new Scope("https://www.googleapis.com/auth/plus.login");
    public static final Scope SCOPE_PLUS_PROFILE = new Scope("https://www.googleapis.com/auth/plus.me");
    public static final Moments MomentsApi = new zztp();
    public static final People PeopleApi = new zztq();
    public static final Account AccountApi = new zztm();
    public static final zzb zzauf = new zzto();
    public static final com.google.android.gms.plus.zza zzaug = new zztn();

    private Plus() {
    }

    public static zze zzf(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzx.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Plus.API Api. Pass this into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.zzb(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Plus.API and is not connected to Plus. Use GoogleApiClient.hasConnectedApi(Plus.API) to guard this call.");
        }
        return bl2 ? (zze)googleApiClient.zza(zzGR) : null;
    }

    public static abstract class zza<R extends Result>
    extends zza.zza<R, zze> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzGR, googleApiClient);
        }
    }

    public static final class PlusOptions
    implements Api.ApiOptions.Optional {
        final String zzauh;
        final Set<String> zzaui;

        private PlusOptions() {
            this.zzauh = null;
            this.zzaui = new HashSet<String>();
        }

        private PlusOptions(Builder builder) {
            this.zzauh = builder.zzauh;
            this.zzaui = builder.zzaui;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            String zzauh;
            final Set<String> zzaui = new HashSet<String>();

            public Builder setServerClientId(String clientId) {
                this.zzauh = clientId;
                return this;
            }

            public Builder addActivityTypes(String ... activityTypes) {
                zzx.zzb((Object)activityTypes, (Object)"activityTypes may not be null.");
                for (int i = 0; i < activityTypes.length; ++i) {
                    this.zzaui.add(activityTypes[i]);
                }
                return this;
            }

            public PlusOptions build() {
                return new PlusOptions(this);
            }
        }
    }
}

