/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final zzg CREATOR = new zzg();
    private final int zzzH;
    private final List<LatLng> zzavD;
    private final List<List<LatLng>> zzavE;
    private float zzava = 10.0f;
    private int zzavb = -16777216;
    private int zzavc = 0;
    private float zzavd = 0.0f;
    private boolean zzave = true;
    private boolean zzavF = false;

    public PolygonOptions() {
        this.zzzH = 1;
        this.zzavD = new ArrayList<LatLng>();
        this.zzavE = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.zzzH = versionCode;
        this.zzavD = points;
        this.zzavE = holes;
        this.zzava = strokeWidth;
        this.zzavb = strokeColor;
        this.zzavc = fillColor;
        this.zzavd = zIndex;
        this.zzave = visible;
        this.zzavF = geodesic;
    }

    int getVersionCode() {
        return this.zzzH;
    }

    List zztT() {
        return this.zzavE;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzg.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.zzavD.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.zzavD.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.zzavD.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.zzavE.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zzava = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.zzavb = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.zzavc = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zzavd = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zzave = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.zzavF = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzavD;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzavE;
    }

    public float getStrokeWidth() {
        return this.zzava;
    }

    public int getStrokeColor() {
        return this.zzavb;
    }

    public int getFillColor() {
        return this.zzavc;
    }

    public float getZIndex() {
        return this.zzavd;
    }

    public boolean isVisible() {
        return this.zzave;
    }

    public boolean isGeodesic() {
        return this.zzavF;
    }
}

