/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzd;

public final class LatLngBounds
implements SafeParcelable {
    public static final zzd CREATOR = new zzd();
    private final int zzzH;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        zzv.zzb((Object)southwest, (Object)"null southwest");
        zzv.zzb((Object)northeast, (Object)"null northeast");
        zzv.zzb((northeast.latitude >= southwest.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{southwest.latitude, northeast.latitude});
        this.zzzH = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.zzd(latLng.latitude) && this.zze(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d = Math.min(this.southwest.latitude, latLng.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng.longitude;
        if (!this.zze(d5)) {
            if (LatLngBounds.zzb(d4, d5) < LatLngBounds.zzc(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public LatLng getCenter() {
        double d = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d2 = this.southwest.longitude;
        double d3 = this.northeast.longitude;
        double d4 = d2 <= d3 ? (d3 + d2) / 2.0 : (d3 + 360.0 + d2) / 2.0;
        return new LatLng(d, d4);
    }

    private static double zzb(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzc(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private boolean zzd(double d) {
        return this.southwest.latitude <= d && d <= this.northeast.latitude;
    }

    private boolean zze(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("southwest", (Object)this.southwest).zzg("northeast", (Object)this.northeast).toString();
    }

    public static final class Builder {
        private double zzavq = Double.POSITIVE_INFINITY;
        private double zzavr = Double.NEGATIVE_INFINITY;
        private double zzavs = Double.NaN;
        private double zzavt = Double.NaN;

        public Builder include(LatLng point) {
            this.zzavq = Math.min(this.zzavq, point.latitude);
            this.zzavr = Math.max(this.zzavr, point.latitude);
            double d = point.longitude;
            if (Double.isNaN(this.zzavs)) {
                this.zzavs = d;
                this.zzavt = d;
            } else if (!this.zze(d)) {
                if (LatLngBounds.zzb(this.zzavs, d) < LatLngBounds.zzc(this.zzavt, d)) {
                    this.zzavs = d;
                } else {
                    this.zzavt = d;
                }
            }
            return this;
        }

        private boolean zze(double d) {
            if (this.zzavs <= this.zzavt) {
                return this.zzavs <= d && d <= this.zzavt;
            }
            return this.zzavs <= d || d <= this.zzavt;
        }

        public LatLngBounds build() {
            zzv.zza((!Double.isNaN(this.zzavs) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zzavq, this.zzavs), new LatLng(this.zzavr, this.zzavt));
        }
    }
}

