/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int zzzH;
    private BitmapDescriptor zzavg;
    private LatLng zzavh;
    private float zzavi;
    private float zzavj;
    private LatLngBounds zzavk;
    private float zzauW;
    private float zzavd;
    private boolean zzave = true;
    private float zzavl = 0.0f;
    private float zzavm = 0.5f;
    private float zzavn = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.zzzH = versionCode;
        this.zzavg = new BitmapDescriptor(zzd.zza.zzat((IBinder)wrappedImage));
        this.zzavh = location;
        this.zzavi = width;
        this.zzavj = height;
        this.zzavk = bounds;
        this.zzauW = bearing;
        this.zzavd = zIndex;
        this.zzave = visible;
        this.zzavl = transparency;
        this.zzavm = anchorU;
        this.zzavn = anchorV;
    }

    public GroundOverlayOptions() {
        this.zzzH = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    IBinder zztR() {
        return this.zzavg.zztp().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.zzavg = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u, float v) {
        this.zzavm = u;
        this.zzavn = v;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        zzv.zza((this.zzavk == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzv.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzv.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        zzv.zza((this.zzavk == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzv.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzv.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzv.zzb((height >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(location, width, height);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzavh = latLng;
        this.zzavi = f;
        this.zzavj = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        zzv.zza((this.zzavh == null ? 1 : 0) != 0, (Object)("Position has already been set using position: " + this.zzavh));
        this.zzavk = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.zzauW = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.zzavd = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.zzave = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        zzv.zzb((transparency >= 0.0f && transparency <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzavl = transparency;
        return this;
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public BitmapDescriptor getImage() {
        return this.zzavg;
    }

    public LatLng getLocation() {
        return this.zzavh;
    }

    public float getWidth() {
        return this.zzavi;
    }

    public float getHeight() {
        return this.zzavj;
    }

    public LatLngBounds getBounds() {
        return this.zzavk;
    }

    public float getBearing() {
        return this.zzauW;
    }

    public float getZIndex() {
        return this.zzavd;
    }

    public float getTransparency() {
        return this.zzavl;
    }

    public float getAnchorU() {
        return this.zzavm;
    }

    public float getAnchorV() {
        return this.zzavn;
    }

    public boolean isVisible() {
        return this.zzave;
    }
}

