/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzx;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    private final zzb zzauK = new zzb(this);
    private GoogleMap zzatY;

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions options) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    protected IMapFragmentDelegate zztC() {
        this.zzauK.zztD();
        if (this.zzauK.zzou() == null) {
            return null;
        }
        return ((zza)this.zzauK.zzou()).zztC();
    }

    @Deprecated
    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.zztC();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.zzatY == null || this.zzatY.zztr().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.zzatY = new GoogleMap(iGoogleMapDelegate);
        }
        return this.zzatY;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzauK.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.zzauK.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zzauK.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.zzauK.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.zzauK.onCreateView(inflater, container, savedInstanceState);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzauK.onResume();
    }

    public void onPause() {
        this.zzauK.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.zzauK.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzauK.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzauK.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.zzauK.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzv.zzbI((String)"getMapAsync must be called on the main thread.");
        this.zzauK.getMapAsync(callback);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzTb;
        protected zzf<zza> zzauc;
        private Activity zzpf;
        private final List<OnMapReadyCallback> zzaud = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzTb = fragment;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzauc = zzf2;
            this.zztD();
        }

        public void zztD() {
            if (this.zzpf != null && this.zzauc != null && this.zzou() == null) {
                try {
                    MapsInitializer.initialize((Context)this.zzpf);
                    IMapFragmentDelegate iMapFragmentDelegate = zzy.zzah((Context)this.zzpf).zzk(zze.zzt((Object)this.zzpf));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzauc.zza((LifecycleDelegate)new zza(this.zzTb, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaud) {
                        ((zza)this.zzou()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaud.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.zzpf = activity;
            this.zztD();
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzou() != null) {
                ((zza)this.zzou()).getMapAsync(callback);
            } else {
                this.zzaud.add(callback);
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment zzTb;
        private final IMapFragmentDelegate zzatZ;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzatZ = (IMapFragmentDelegate)zzv.zzr((Object)iMapFragmentDelegate);
            this.zzTb = (Fragment)zzv.zzr((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.zzatZ.onInflate(zze.zzt((Object)activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.zzTb.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    zzx.zza(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.zzatZ.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            zzd zzd2;
            try {
                zzd2 = this.zzatZ.onCreateView(zze.zzt((Object)inflater), zze.zzt((Object)container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzg((zzd)zzd2);
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzatZ.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzatZ.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            try {
                this.zzatZ.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.zzatZ.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzatZ.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzatZ.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate zztC() {
            return this.zzatZ;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzatZ.getMapAsync(new zzm.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

