/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzaue;
    private GoogleMap zzatY;

    public MapView(Context context) {
        super(context);
        this.zzaue = new zzb((ViewGroup)this, context, null);
        this.init();
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzaue = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zzaue = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, GoogleMapOptions options) {
        super(context);
        this.zzaue = new zzb((ViewGroup)this, context, options);
        this.init();
    }

    private void init() {
        this.setClickable(true);
    }

    @Deprecated
    public final GoogleMap getMap() {
        if (this.zzatY != null) {
            return this.zzatY;
        }
        this.zzaue.zztD();
        if (this.zzaue.zzou() == null) {
            return null;
        }
        try {
            this.zzatY = new GoogleMap(((zza)this.zzaue.zzou()).zztE().getMap());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this.zzatY;
    }

    public final void onCreate(Bundle savedInstanceState) {
        this.zzaue.onCreate(savedInstanceState);
        if (this.zzaue.zzou() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzaue.onResume();
    }

    public final void onPause() {
        this.zzaue.onPause();
    }

    public final void onDestroy() {
        this.zzaue.onDestroy();
    }

    public final void onLowMemory() {
        this.zzaue.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle outState) {
        this.zzaue.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzv.zzbI((String)"getMapAsync() must be called on the main thread");
        this.zzaue.getMapAsync(callback);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzauj;
        private final Context mContext;
        protected zzf<zza> zzauc;
        private final GoogleMapOptions zzauk;
        private final List<OnMapReadyCallback> zzaud = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzauj = viewGroup;
            this.mContext = context;
            this.zzauk = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzauc = zzf2;
            this.zztD();
        }

        public void zztD() {
            if (this.zzauc != null && this.zzou() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzy.zzah(this.mContext).zza(zze.zzt((Object)this.mContext), this.zzauk);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzauc.zza((LifecycleDelegate)new zza(this.zzauj, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaud) {
                        ((zza)this.zzou()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaud.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzou() != null) {
                ((zza)this.zzou()).getMapAsync(callback);
            } else {
                this.zzaud.add(callback);
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzauf;
        private final IMapViewDelegate zzaug;
        private View zzauh;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzaug = (IMapViewDelegate)zzv.zzr((Object)iMapViewDelegate);
            this.zzauf = (ViewGroup)zzv.zzr((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaug.onCreate(savedInstanceState);
                this.zzauh = (View)zze.zzg((zzd)this.zzaug.getView());
                this.zzauf.removeAllViews();
                this.zzauf.addView(this.zzauh);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaug.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaug.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzaug.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaug.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaug.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapViewDelegate zztE() {
            return this.zzaug;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaug.getMapAsync(new zzm.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

