/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.zzaa;
import com.google.android.gms.maps.model.zzi;
import com.google.android.gms.maps.model.zzj;

public final class LatLng
implements SafeParcelable {
    public static final zzi CREATOR = new zzi();
    private final int zzFG;
    public final double latitude;
    public final double longitude;

    LatLng(int versionCode, double latitude, double longitude) {
        this.zzFG = versionCode;
        this.longitude = -180.0 <= longitude && longitude < 180.0 ? longitude : ((longitude - 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
        this.latitude = Math.max(-90.0, Math.min(90.0, latitude));
    }

    public LatLng(double latitude, double longitude) {
        this(1, latitude, longitude);
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (zzaa.zzqF()) {
            zzj.zza(this, out, flags);
        } else {
            zzi.zza(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.latitude);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.longitude);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        return n2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLng)) {
            return false;
        }
        LatLng latLng = (LatLng)o;
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(latLng.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(latLng.longitude);
    }

    public String toString() {
        return "lat/lng: (" + this.latitude + "," + this.longitude + ")";
    }
}

