/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzx {
    private static Context zzaqM;
    private static zzc zzaqN;

    public static zzc zzac(Context context) throws GooglePlayServicesNotAvailableException {
        com.google.android.gms.common.internal.zzx.zzl((Object)context);
        if (zzaqN != null) {
            return zzaqN;
        }
        zzx.zzad(context);
        zzaqN = zzx.zzae(context);
        try {
            zzaqN.zzb(zze.zzn((Object)zzx.getRemoteContext(context).getResources()), 7095000);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzaqN;
    }

    public static boolean zzqC() {
        return false;
    }

    private static Class<?> zzqD() {
        try {
            if (Build.VERSION.SDK_INT < 15) {
                return Class.forName("com.google.android.gms.maps.internal.CreatorImplGmm6");
            }
            return Class.forName("com.google.android.gms.maps.internal.CreatorImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private static void zzad(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzae(Context context) {
        if (zzx.zzqC()) {
            Log.i((String)zzx.class.getSimpleName(), (String)"Making Creator statically");
            Class<?> clazz = zzx.zzqD();
            return (zzc)zzx.zzc(clazz);
        }
        Log.i((String)zzx.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzx.zza(zzx.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzbt(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (zzaqM == null) {
            zzaqM = zzx.zzqC() ? context.getApplicationContext() : GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return zzaqM;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzx.zzc(((ClassLoader)com.google.android.gms.common.internal.zzx.zzl((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to find dynamic class " + string);
        }
    }

    private static <T> T zzc(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Unable to instantiate the dynamic class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unable to call the default constructor of " + clazz.getName());
        }
    }
}

